/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.abst.distort.FDistort;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.gui.ListDisplayPanel;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.ImagePyramid;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class ImagePyramidPanel<T extends ImageGray<T>>
extends ListDisplayPanel {
    ImagePyramid<T> pyramid;
    InterpolatePixelS<T> interp;
    T upscale;
    boolean scaleUp;
    boolean showScales = true;

    public ImagePyramidPanel(ImagePyramid<T> pyramid, boolean scaleUp) {
        this.set(pyramid, scaleUp);
        this.render();
        this.setPreferredSize(new Dimension(pyramid.getWidth(0), pyramid.getHeight(0)));
    }

    public ImagePyramidPanel() {
    }

    public void setShowScales(boolean showScales) {
        this.showScales = showScales;
    }

    public void set(ImagePyramid<T> pyramid, boolean scaleUp) {
        this.pyramid = pyramid;
        this.scaleUp = scaleUp;
    }

    public void render() {
        this.reset();
        if (this.pyramid == null) {
            return;
        }
        if (this.scaleUp) {
            this.scaleUpLayers();
        } else {
            this.doNotScaleLayers();
        }
    }

    private void doNotScaleLayers() {
        int N = this.pyramid.getNumLayers();
        for (int i = 0; i < N; ++i) {
            BufferedImage b = ConvertBufferedImage.convertTo((ImageBase)this.pyramid.getLayer(i), null, (boolean)true);
            this.addImage(b, String.format("%5.2f", this.pyramid.getScale(i)));
        }
    }

    private void scaleUpLayers() {
        ImageGray l = (ImageGray)this.pyramid.getLayer(0);
        if (this.upscale == null) {
            this.interp = FactoryInterpolation.nearestNeighborPixelS(l.getClass());
            this.upscale = (ImageGray)l.createNew(l.width, l.height);
        } else {
            this.upscale.reshape(l.width, l.height);
        }
        int N = this.pyramid.getNumLayers();
        for (int i = 0; i < N; ++i) {
            new FDistort(this.pyramid.getLayer(i), this.upscale).interpNN().scaleExt().apply();
            BufferedImage b = ConvertBufferedImage.convertTo(this.upscale, null, (boolean)true);
            if (this.showScales) {
                this.addImage(b, String.format("%5.2f", this.pyramid.getScale(i)));
                continue;
            }
            this.addImage(b, String.format("%5.2f", this.pyramid.getSigma(i)));
        }
    }
}

