/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.abst.tracker.PointTracker;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.factory.sfm.ConfigStereoDualTrackPnP;
import boofcv.factory.sfm.ConfigVisOdomTrackPnP;
import boofcv.factory.sfm.FactoryVisualOdometry;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.ControlPanelDetDescAssocBase;
import boofcv.gui.controls.ControlPanelPointTrackers;
import boofcv.gui.controls.ControlPanelVisOdomTrackPnP;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;

public class ControlPanelStereoDualTrackPnP
extends JTabbedPane {
    ControlPanelVisOdomTrackPnP controlPnpDepth;
    ControlPanelPointTrackers controlTrackers;
    StereoControls controlStereo;
    final Listener listener;
    public final ConfigStereoDualTrackPnP config;

    public ControlPanelStereoDualTrackPnP(ConfigStereoDualTrackPnP config, Listener listener) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.listener = listener;
        this.config = config;
        this.controlPnpDepth = new ControlPanelVisOdomTrackPnP(listener::changedStereoDualTrackPnP, config.scene);
        this.controlTrackers = new ControlPanelPointTrackers(listener::changedStereoDualTrackPnP, config.tracker);
        this.controlStereo = new StereoControls();
        JPanel panelAlgControls = new JPanel(new BorderLayout());
        panelAlgControls.add("Center", this.controlPnpDepth);
        this.addTab("VO", panelAlgControls);
        this.addTab("Tracker", this.controlTrackers);
        this.addTab("Stereo", this.controlStereo);
    }

    public <T extends ImageGray<T>> StereoVisualOdometry<T> createVisOdom(Class<T> imageType) {
        PointTracker trackerLeft = this.controlTrackers.createTracker(ImageType.single(imageType));
        PointTracker trackerRight = this.controlTrackers.createTracker(ImageType.single(imageType));
        return FactoryVisualOdometry.stereoDualTrackerPnP((ConfigVisOdomTrackPnP)this.controlPnpDepth.config, trackerLeft, trackerRight, (ConfigStereoDualTrackPnP)this.config, imageType);
    }

    public static interface Listener {
        public void changedStereoDualTrackPnP();
    }

    public class StereoControls
    extends StandardAlgConfigPanel {
        JSpinner spinnerScaleRadius;
        JSpinner spinnerEpipolarTol;
        DescribeControl panelDescribe;

        public StereoControls() {
            this.panelDescribe = new DescribeControl();
            this.setBorder(BorderFactory.createEmptyBorder());
            this.spinnerScaleRadius = this.spinner(ControlPanelStereoDualTrackPnP.this.config.stereoRadius, 0.0, 500.0, 1.0);
            this.spinnerEpipolarTol = this.spinner(ControlPanelStereoDualTrackPnP.this.config.epipolarTol, 0.0, 100.0, 1.0);
            this.addLabeled(this.spinnerScaleRadius, "Describe Radius", "Size of region covered by descriptor");
            this.addLabeled(this.spinnerEpipolarTol, "Epipolar Tol.", "Maximum distance away from the epipolar line two features can be");
            this.add(this.panelDescribe);
        }

        @Override
        public void controlChanged(Object source) {
            if (source == this.spinnerScaleRadius) {
                ControlPanelStereoDualTrackPnP.this.config.stereoRadius = ((Number)this.spinnerScaleRadius.getValue()).doubleValue();
            } else if (source == this.spinnerEpipolarTol) {
                ControlPanelStereoDualTrackPnP.this.config.epipolarTol = ((Number)this.spinnerEpipolarTol.getValue()).doubleValue();
            }
            ControlPanelStereoDualTrackPnP.this.listener.changedStereoDualTrackPnP();
        }
    }

    public class DescribeControl
    extends ControlPanelDetDescAssocBase {
        JPanel panelDescriptor = new JPanel(new BorderLayout());

        public DescribeControl() {
            this.configDetDesc.copyRefFrom(ControlPanelStereoDualTrackPnP.this.config.stereoDescribe);
            this.panelDescriptor.setBorder(BorderFactory.createTitledBorder("Descriptor"));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.initializeControlsGUI();
            this.addLabeled(this.comboDescribe, "Type");
            this.add(this.panelDescriptor);
            this.handleDescriptorChanged();
        }

        private void handleDescriptorChanged() {
            ControlPanelStereoDualTrackPnP.this.config.stereoDescribe.type = this.configDetDesc.typeDescribe;
            this.panelDescriptor.removeAll();
            this.panelDescriptor.add((Component)this.getDescriptorPanel(), "Center");
            this.panelDescriptor.invalidate();
            ControlPanelStereoDualTrackPnP.this.repaint();
        }

        @Override
        protected void handleControlsUpdated() {
            ControlPanelStereoDualTrackPnP.this.listener.changedStereoDualTrackPnP();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.comboDescribe == e.getSource()) {
                this.configDetDesc.typeDescribe = ConfigDescribeRegion.Type.values()[this.comboDescribe.getSelectedIndex()];
                this.handleDescriptorChanged();
                ControlPanelStereoDualTrackPnP.this.listener.changedStereoDualTrackPnP();
            }
        }
    }
}

