/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.sfm.ConfigStereoQuadPnP;
import boofcv.factory.sfm.FactoryVisualOdometry;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.ControlPanelDetDescAssocBase;
import boofcv.gui.controls.JConfigLength;
import boofcv.gui.feature.ControlPanelAssociateGreedy;
import boofcv.struct.image.ImageGray;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ControlPanelStereoQuadPnP
extends JTabbedPane {
    public final ConfigStereoQuadPnP config;
    final ControlPanelDetDescAssocBase panelFeatures;
    final ControlPanelMotion panelMotion;
    final ControlPanelAssociate panelAssociate;
    final Listener listener;

    public ControlPanelStereoQuadPnP(ConfigStereoQuadPnP config, Listener listener) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.listener = listener;
        this.config = config;
        this.panelFeatures = new ControlPanelFeatures();
        this.panelMotion = new ControlPanelMotion();
        this.panelAssociate = new ControlPanelAssociate();
        this.addTab("Motion", this.panelMotion);
        this.addTab("Feat", this.panelFeatures);
        this.addTab("Assoc", this.panelAssociate);
    }

    public <T extends ImageGray<T>> StereoVisualOdometry<T> createVisOdom(Class<T> imageType) {
        return FactoryVisualOdometry.stereoQuadPnP((ConfigStereoQuadPnP)this.config, imageType);
    }

    public static interface Listener {
        public void changedStereoQuadPnP();
    }

    public class ControlPanelFeatures
    extends ControlPanelDetDescAssocBase {
        private final JPanel controlPanel = new JPanel(new BorderLayout());

        public ControlPanelFeatures() {
            this.configDetDesc = ControlPanelStereoQuadPnP.this.config.detectDescribe;
            this.initializeControlsGUI();
            this.addLabeled(this.comboDetect, "Detect", "Point feature detectors");
            this.addLabeled(this.comboDescribe, "Describe", "Point feature Descriptors");
            this.add(this.controlPanel);
            this.updateActiveControls(0);
        }

        private void updateActiveControls(int which) {
            String title;
            JPanel inside;
            this.controlPanel.removeAll();
            switch (which) {
                case 0: {
                    inside = this.getDetectorPanel();
                    title = "Detect";
                    break;
                }
                case 1: {
                    inside = this.getDescriptorPanel();
                    title = "Describe";
                    break;
                }
                default: {
                    throw new RuntimeException("BUG!");
                }
            }
            this.controlPanel.setBorder(BorderFactory.createTitledBorder(title));
            if (inside != null) {
                this.controlPanel.add("Center", inside);
            }
            this.controlPanel.validate();
            SwingUtilities.invokeLater(this::repaint);
        }

        @Override
        public void controlChanged(Object source) {
            int which = -1;
            if (source == this.comboDetect) {
                this.configDetDesc.typeDetector = ConfigDetectInterestPoint.Type.values()[this.comboDetect.getSelectedIndex()];
                which = 0;
            } else if (source == this.comboDescribe) {
                this.configDetDesc.typeDescribe = ConfigDescribeRegion.Type.values()[this.comboDescribe.getSelectedIndex()];
                which = 1;
            } else {
                throw new RuntimeException("BUG!");
            }
            this.updateActiveControls(which);
            ControlPanelStereoQuadPnP.this.listener.changedStereoQuadPnP();
        }

        @Override
        protected void handleControlsUpdated() {
            ControlPanelStereoQuadPnP.this.listener.changedStereoQuadPnP();
        }
    }

    public class ControlPanelMotion
    extends StandardAlgConfigPanel {
        private final EnumPNP[] VALUES_PNP = new EnumPNP[]{EnumPNP.P3P_GRUNERT, EnumPNP.P3P_FINSTERWALDER, EnumPNP.EPNP};
        private final JSpinner spinRansacIter;
        private final JSpinner spinRansacTol;
        private final JSpinner spinRefinePnP;
        private final JComboBox<String> comboPnpType;
        private final JSpinner spinBundleMaxIter;

        public ControlPanelMotion() {
            this.spinRansacIter = this.spinner(ControlPanelStereoQuadPnP.this.config.ransac.iterations, 0, 9999, 1);
            this.spinRansacTol = this.spinner(ControlPanelStereoQuadPnP.this.config.ransac.inlierThreshold, 0.0, 50.0, 0.2);
            this.spinRefinePnP = this.spinner(ControlPanelStereoQuadPnP.this.config.refineIterations, 0, 999, 1);
            this.comboPnpType = this.combo(ControlPanelStereoQuadPnP.this.config.pnp.ordinal(), this.VALUES_PNP);
            this.spinBundleMaxIter = this.spinner(ControlPanelStereoQuadPnP.this.config.bundleConverge.maxIterations, 0, 999, 1);
            StandardAlgConfigPanel panelPnP = new StandardAlgConfigPanel();
            panelPnP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "PnP"));
            panelPnP.addLabeled(this.spinRansacIter, "RANSAC Iter", "Maximum RANSAC iterations");
            panelPnP.addLabeled(this.spinRansacTol, "Inlier Tol", "RANSAC inlier tolerance");
            panelPnP.addLabeled(this.spinRefinePnP, "Refine Iter", "Non-linear refinement iterations for PNP");
            panelPnP.addAlignCenter(this.comboPnpType);
            this.comboPnpType.setToolTipText("PNP solution to use in RANSAC");
            StandardAlgConfigPanel panelBundle = new StandardAlgConfigPanel();
            panelBundle.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Bundle"));
            panelBundle.addLabeled(this.spinBundleMaxIter, "Iteration", "Bundle Adjustment Iterations. 0 = disable");
            this.add(ControlPanelMotion.fillHorizontally(panelPnP));
            this.add(ControlPanelMotion.fillHorizontally(panelBundle));
        }

        @Override
        public void controlChanged(Object source) {
            if (this.spinRansacIter == source) {
                ControlPanelStereoQuadPnP.this.config.ransac.iterations = (Integer)this.spinRansacIter.getValue();
            } else if (this.spinRansacTol == source) {
                ControlPanelStereoQuadPnP.this.config.ransac.inlierThreshold = (Double)this.spinRansacTol.getValue();
            } else if (this.spinRefinePnP == source) {
                ControlPanelStereoQuadPnP.this.config.refineIterations = (Integer)this.spinRefinePnP.getValue();
            } else if (this.spinBundleMaxIter == source) {
                ControlPanelStereoQuadPnP.this.config.bundleConverge.maxIterations = (Integer)this.spinBundleMaxIter.getValue();
            } else if (this.comboPnpType == source) {
                ControlPanelStereoQuadPnP.this.config.pnp = this.VALUES_PNP[this.comboPnpType.getSelectedIndex()];
            }
            ControlPanelStereoQuadPnP.this.listener.changedStereoQuadPnP();
        }
    }

    public class ControlPanelAssociate
    extends StandardAlgConfigPanel {
        private final ControlPanelAssociateGreedy controlAssociateF2F;
        private final ControlPanelAssociateGreedy controlAssociateL2R;
        private final JConfigLength controlMaxDistance;
        private final JSpinner spinnerEpipolarTol;

        public ControlPanelAssociate() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.controlAssociateL2R = new ControlPanelAssociateGreedy(ControlPanelStereoQuadPnP.this.config.associateL2R, () -> ControlPanelStereoQuadPnP.this.listener.changedStereoQuadPnP());
            this.controlAssociateF2F = new ControlPanelAssociateGreedy(ControlPanelStereoQuadPnP.this.config.associateF2F.greedy, () -> ControlPanelStereoQuadPnP.this.listener.changedStereoQuadPnP());
            this.controlMaxDistance = this.configLength(ControlPanelStereoQuadPnP.this.config.associateF2F.maximumDistancePixels, 0.0, 2000.0);
            this.controlAssociateL2R.setBorder(BorderFactory.createTitledBorder("Left to Right"));
            this.controlAssociateF2F.setBorder(BorderFactory.createEmptyBorder());
            StandardAlgConfigPanel panelF2F = new StandardAlgConfigPanel();
            panelF2F.add(this.controlAssociateF2F);
            panelF2F.addLabeled(this.controlMaxDistance, "Max Distance", "Maximum distance away two features can be associated");
            panelF2F.setBorder(BorderFactory.createTitledBorder("Frame to Frame"));
            this.controlAssociateL2R.getCheckForwardsBackwards().setEnabled(false);
            this.controlAssociateL2R.getSpinnerRatio().setEnabled(false);
            this.spinnerEpipolarTol = this.spinner(ControlPanelStereoQuadPnP.this.config.epipolarTol, 0.0, 999.9, 0.1);
            this.add(this.controlAssociateL2R);
            this.add(panelF2F);
            this.addLabeled(this.spinnerEpipolarTol, "Stereo Tol", "How far away a point can be from the epipolar line to be considered for a match");
        }

        @Override
        public void controlChanged(Object source) {
            if (source == this.spinnerEpipolarTol) {
                ControlPanelStereoQuadPnP.this.config.epipolarTol = ((Number)this.spinnerEpipolarTol.getValue()).doubleValue();
                ControlPanelStereoQuadPnP.this.listener.changedStereoQuadPnP();
            } else if (source == this.controlMaxDistance) {
                ControlPanelStereoQuadPnP.this.config.associateF2F.maximumDistancePixels.setTo(this.controlMaxDistance.getValue());
                ControlPanelStereoQuadPnP.this.listener.changedStereoQuadPnP();
            }
        }
    }
}

