/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.alg.drawing.FiducialRenderEngine;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class FiducialRenderEngineGraphics2D
extends FiducialRenderEngine {
    protected BufferedImage image = new BufferedImage(1, 1, 1);
    protected Graphics2D g2;
    protected Ellipse2D.Double ellipse = new Ellipse2D.Double();
    protected Rectangle2D.Double rect = new Rectangle2D.Double();
    private int borderPixelsX;
    private int borderPixelsY;
    private final Color white = Color.WHITE;
    private final Color black;
    private Color drawColor = this.black = Color.BLACK;

    public void configure(int borderPixelsX, int borderPixelsY, int markerWidth, int markerHeight) {
        this.borderPixelsX = borderPixelsX;
        this.borderPixelsY = borderPixelsY;
        int width = markerWidth + 2 * borderPixelsX;
        int height = markerHeight + 2 * borderPixelsY;
        this.image = ConvertBufferedImage.checkDeclare((int)width, (int)height, (BufferedImage)this.image, (int)this.image.getType());
        this.g2 = this.image.createGraphics();
        this.g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void init() {
        this.g2.setColor(this.white);
        this.g2.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
    }

    public void setGray(double value) {
        int v = (int)(255.0 * value);
        this.drawColor = new Color(v, v, v);
    }

    public void circle(double cx, double cy, double radius) {
        this.ellipse.setFrame((double)this.borderPixelsX + cx - radius, (double)this.borderPixelsY + cy - radius, radius * 2.0, radius * 2.0);
        this.g2.setColor(this.drawColor);
        this.g2.fill(this.ellipse);
    }

    public void rectangle(double x0, double y0, double x1, double y1) {
        this.rect.setRect((double)this.borderPixelsX + x0, (double)this.borderPixelsY + y0, x1 - x0, y1 - y0);
        this.g2.setColor(this.drawColor);
        this.g2.fill(this.rect);
    }

    public void square(double x0, double y0, double width, double thickness) {
        this.g2.setColor(this.drawColor);
        this.rect.setRect(x0 += (double)this.borderPixelsX, y0 += (double)this.borderPixelsY, width, thickness);
        this.g2.fill(this.rect);
        this.rect.setRect(x0, y0 + width - thickness, width, thickness);
        this.g2.fill(this.rect);
        this.rect.setRect(x0, y0 + thickness, thickness, width - 2.0 * thickness);
        this.g2.fill(this.rect);
        this.rect.setRect(x0 + width - thickness, y0 + thickness, thickness, width - 2.0 * thickness);
        this.g2.fill(this.rect);
    }

    public void draw(GrayU8 image, double x0, double y0, double x1, double y1) {
        double scaleX = (double)image.width / (x1 - x0);
        double scaleY = (double)image.height / (y1 - y0);
        BufferedImage buff = ConvertBufferedImage.convertTo((ImageBase)image, null, (boolean)true);
        AffineTransform original = this.g2.getTransform();
        this.g2.setTransform(AffineTransform.getScaleInstance(scaleX, scaleY));
        this.g2.drawImage((Image)buff, this.borderPixelsX + (int)(x0 + 0.5), this.borderPixelsY + (int)(y0 + 0.5), null);
        this.g2.setTransform(original);
    }

    public void inputToDocument(double x, double y, Point2D_F64 document) {
        document.x = x + (double)this.borderPixelsX;
        document.y = y + (double)this.borderPixelsY;
    }

    public GrayU8 getGrayU8() {
        GrayU8 out = new GrayU8(this.image.getWidth(), this.image.getHeight());
        ConvertBufferedImage.convertFrom((BufferedImage)this.image, (ImageBase)out, (boolean)true);
        return out;
    }

    public GrayF32 getGrayF32() {
        GrayF32 out = new GrayF32(this.image.getWidth(), this.image.getHeight());
        ConvertBufferedImage.convertFrom((BufferedImage)this.image, (ImageBase)out, (boolean)true);
        return out;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getBorderPixelsX() {
        return this.borderPixelsX;
    }

    public int getBorderPixelsY() {
        return this.borderPixelsY;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }
}

