/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.gui.calibration.StereoImageSet;
import boofcv.io.image.UtilImageIO;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;

public class StereoImageSetListSplit
implements StereoImageSet {
    List<String> paths;
    int splitX;
    int selected;

    public StereoImageSetListSplit(List<String> paths, int splitX) {
        this.paths = paths;
        this.splitX = splitX;
    }

    @Override
    public void setSelected(int index) {
        this.selected = index;
    }

    @Override
    public int size() {
        return this.paths.size();
    }

    @Override
    public String getLeftName() {
        return FilenameUtils.getBaseName((String)new File(this.paths.get(this.selected)).getName());
    }

    @Override
    public String getRightName() {
        return this.getLeftName() + "R";
    }

    @Override
    public BufferedImage loadLeft() {
        BufferedImage image = UtilImageIO.loadImage((String)this.paths.get(this.selected));
        Objects.requireNonNull(image);
        BufferedImage half = new BufferedImage(this.splitX, image.getHeight(), image.getType());
        half.createGraphics().drawImage((Image)image, 0, 0, null);
        return half;
    }

    @Override
    public BufferedImage loadRight() {
        BufferedImage image = Objects.requireNonNull(UtilImageIO.loadImage((String)this.paths.get(this.selected)));
        int width = image.getWidth() - this.splitX;
        int height = image.getHeight();
        BufferedImage half = new BufferedImage(width, image.getHeight(), image.getType());
        half.createGraphics().drawImage(image, 0, 0, width, height, this.splitX, 0, image.getWidth(), height, null);
        return half;
    }
}

