/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.mesh;

import boofcv.gui.mesh.FirstPersonShooterCamera;
import boofcv.gui.mesh.Swing3dCameraControl;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.mesh.VertexMesh;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.jetbrains.annotations.Nullable;

public class FirstPersonCameraControl
extends MouseAdapter
implements Swing3dCameraControl {
    public int maxSamplePoints = 1000;
    final FirstPersonShooterCamera fps = new FirstPersonShooterCamera();
    Runnable handleCameraChanged = () -> {};
    int prevX;
    int prevY;
    double translateScale = 1.0;
    private final Se3_F64 worldToCamera = new Se3_F64();
    private final KeyPressHandler keyHandler = new KeyPressHandler();
    @Nullable
    ScheduledExecutorService pressedTask = null;
    final Object lockPressed = new Object();
    private final FocusListener focusListener = new FocusListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusGained(FocusEvent e) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(FirstPersonCameraControl.this.keyHandler);
            Object object = FirstPersonCameraControl.this.lockPressed;
            synchronized (object) {
                FirstPersonCameraControl.this.pressedTask = Executors.newScheduledThreadPool(1);
                FirstPersonCameraControl.this.pressedTask.scheduleAtFixedRate(() -> FirstPersonCameraControl.this.keyHandler.applyKeyAction(), 100L, 30L, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(FirstPersonCameraControl.this.keyHandler);
            FirstPersonCameraControl.this.stopPressedTask();
        }
    };

    @Override
    public void attachControls(JComponent parent) {
        this.keyHandler.reset();
        parent.addMouseListener(this);
        parent.addMouseMotionListener(this);
        parent.addMouseWheelListener(this);
        parent.addFocusListener(this.focusListener);
    }

    @Override
    public void detachControls(JComponent parent) {
        parent.removeMouseListener(this);
        parent.removeMouseMotionListener(this);
        parent.removeMouseWheelListener(this);
        parent.removeFocusListener(this.focusListener);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyHandler);
        this.stopPressedTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPressedTask() {
        Object object = this.lockPressed;
        synchronized (object) {
            if (this.pressedTask != null) {
                this.pressedTask.shutdown();
                this.pressedTask = null;
            }
        }
    }

    @Override
    public void selectInitialParameters(VertexMesh mesh) {
        int N = Math.min(this.maxSamplePoints, mesh.vertexes.size());
        if (N == 0) {
            this.fps.motionUnit = 1.0;
            return;
        }
        DogArray sampled = new DogArray(Point3D_F64::new);
        sampled.reserve(N);
        for (int i = 0; i < N; ++i) {
            int vertIndex = i * mesh.vertexes.size() / N;
            mesh.vertexes.getCopy(vertIndex, (Point3D_F64)sampled.grow());
        }
        DogArray_F64 values = new DogArray_F64();
        values.resize(sampled.size);
        Point3D_F64 median = new Point3D_F64();
        for (int axis = 0; axis < 3; ++axis) {
            int _axis = axis;
            sampled.forIdx((idx, v) -> values.set(idx, v.getIdx(_axis)));
            values.sort();
            median.setIdx(axis, values.getFraction(0.5));
        }
        this.fps.motionUnit = median.norm() / 150.0;
    }

    @Override
    public void reset() {
        this.fps.resetView();
    }

    @Override
    public void setCamera(CameraPinhole intrinsics) {
        this.fps.getCamera().setTo(intrinsics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Se3_F64 getWorldToCamera() {
        FirstPersonShooterCamera firstPersonShooterCamera = this.fps;
        synchronized (firstPersonShooterCamera) {
            this.worldToCamera.setTo(this.fps.worldToView);
        }
        return this.worldToCamera;
    }

    @Override
    public void setChangeHandler(Runnable handler) {
        this.handleCameraChanged = handler;
    }

    @Override
    public String getHelpText() {
        return "First Person Shooter Controls\na   left\nd   right\nw   forward\ns   backwards\nq   Own\ne   Up\nMouse for pan and tilt\nMouse right for roll\n";
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        FirstPersonShooterCamera firstPersonShooterCamera = this.fps;
        synchronized (firstPersonShooterCamera) {
            if (e.isShiftDown() || SwingUtilities.isRightMouseButton(e)) {
                this.fps.mouseDragRoll(this.prevX, this.prevY, e.getX(), e.getY());
            } else {
                this.fps.mouseDragPanTilt(this.prevX, this.prevY, e.getX(), e.getY());
            }
        }
        this.prevX = e.getX();
        this.prevY = e.getY();
        this.handleCameraChanged.run();
    }

    public FirstPersonShooterCamera getFps() {
        return this.fps;
    }

    public void setHandleCameraChanged(Runnable handleCameraChanged) {
        this.handleCameraChanged = handleCameraChanged;
    }

    private class KeyPressHandler
    implements KeyEventDispatcher {
        boolean downW;
        boolean downA;
        boolean downS;
        boolean downD;
        boolean downQ;
        boolean downE;

        private KeyPressHandler() {
        }

        public void reset() {
            this.downE = false;
            this.downQ = false;
            this.downD = false;
            this.downS = false;
            this.downA = false;
            this.downW = false;
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            boolean pressed;
            switch (e.getID()) {
                case 401: {
                    pressed = true;
                    break;
                }
                case 402: {
                    pressed = false;
                    break;
                }
                default: {
                    return false;
                }
            }
            switch (e.getKeyCode()) {
                case 87: {
                    this.downW = pressed;
                    break;
                }
                case 65: {
                    this.downA = pressed;
                    break;
                }
                case 83: {
                    this.downS = pressed;
                    break;
                }
                case 68: {
                    this.downD = pressed;
                    break;
                }
                case 81: {
                    this.downQ = pressed;
                    break;
                }
                case 69: {
                    this.downE = pressed;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.applyKeyAction();
            return false;
        }

        public void applyKeyAction() {
            int dx = 0;
            int dy = 0;
            int dz = 0;
            if (this.downW) {
                dz = -1;
            }
            if (this.downS) {
                dz = 1;
            }
            if (this.downA) {
                dx = 1;
            }
            if (this.downD) {
                dx = -1;
            }
            if (this.downQ) {
                dy = -1;
            }
            if (this.downE) {
                dy = 1;
            }
            if (dx == 0 && dy == 0 && dz == 0) {
                return;
            }
            FirstPersonCameraControl.this.fps.translateKey(dx, dy, dz, FirstPersonCameraControl.this.translateScale);
            FirstPersonCameraControl.this.handleCameraChanged.run();
        }
    }
}

