/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.stereo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class RectifiedPairPanel
extends JPanel
implements MouseListener {
    BufferedImage image1;
    BufferedImage image2;
    int mouseY = -10;
    int mouseX;
    boolean scaleToWindow;

    public RectifiedPairPanel(boolean scaleToWindow) {
        this.addMouseListener(this);
        this.scaleToWindow = scaleToWindow;
    }

    public RectifiedPairPanel(boolean scaleToWindow, BufferedImage image1, BufferedImage image2) {
        this(scaleToWindow);
        this.setImages(image1, image2);
        int h = Math.max(image1.getHeight(), image2.getHeight());
        int w = image1.getWidth() + image2.getWidth();
        this.setPreferredSize(new Dimension(w, h));
        this.setMinimumSize(new Dimension(w, h));
    }

    public void setImages(BufferedImage image1, BufferedImage image2) {
        this.image1 = image1;
        this.image2 = image2;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        BufferedImage image1 = this.image1;
        BufferedImage image2 = this.image2;
        if (image1 == null || image2 == null) {
            return;
        }
        double scale = 1.0;
        if (this.scaleToWindow) {
            scale = this.computeScale();
            AffineTransform orig = g2.getTransform();
            AffineTransform combined = (AffineTransform)orig.clone();
            combined.concatenate(AffineTransform.getScaleInstance(scale, scale));
            g2.setTransform(combined);
            g2.drawImage((Image)image1, 0, 0, null);
            g2.drawImage((Image)image2, image1.getWidth(), 0, null);
            g2.setTransform(orig);
        } else {
            g2.drawImage((Image)image1, 0, 0, null);
            g2.drawImage((Image)image2, image1.getWidth(), 0, null);
        }
        if (this.mouseY >= 0) {
            int x = this.mouseX >= image1.getWidth() ? this.mouseX - image1.getWidth() : this.mouseX;
            int leftX = (int)((double)x * scale + 0.5);
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(Color.GREEN);
            g2.drawLine(leftX, 0, leftX, this.getHeight());
            int rightX = (int)(scale * (double)(x + image1.getWidth()) + 0.5);
            g2.setColor(Color.GREEN);
            g2.drawLine(rightX, 0, rightX, this.getHeight());
        }
        g2.setColor(Color.RED);
        g2.setStroke(new BasicStroke(3.0f));
        g2.drawLine(0, (int)(scale * (double)this.mouseY + 0.5), this.getWidth(), (int)(scale * (double)this.mouseY + 0.5));
    }

    private double computeScale() {
        double scaleY;
        int h = Math.max(this.image1.getHeight(), this.image2.getHeight());
        int w = this.image1.getWidth() + this.image2.getWidth();
        double scaleX = (double)this.getWidth() / (double)w;
        double scale = Math.min(scaleX, scaleY = (double)this.getHeight() / (double)h);
        if (scale > 1.0) {
            scale = 1.0;
        }
        return scale;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        double scale = this.scaleToWindow ? this.computeScale() : 1.0;
        this.mouseY = (int)((double)e.getY() / scale + 0.5);
        this.mouseX = (int)((double)e.getX() / scale + 0.5);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

