/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.alg.misc.GImageStatistics;
import boofcv.gui.BoofSwingUtil;
import boofcv.gui.image.ImageGridPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ScaleOptions;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ShowImages {
    public static void showDialog(BufferedImage img) {
        ImageIcon icon = new ImageIcon();
        icon.setImage(img);
        JOptionPane.showMessageDialog(null, icon);
    }

    public static ImageGridPanel showGrid(int numColumns, String title, BufferedImage ... images) {
        JFrame frame = new JFrame(title);
        int numRows = images.length / numColumns + images.length % numColumns;
        ImageGridPanel panel = new ImageGridPanel(numRows, numColumns, images);
        frame.add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
        return panel;
    }

    public static ImagePanel showWindow(BufferedImage img, String title) {
        return ShowImages.showWindow(img, title, false);
    }

    public static ImagePanel showWindow(BufferedImage img, String title, boolean closeOnExit) {
        JFrame frame = new JFrame(title);
        ImagePanel panel = new ImagePanel(img);
        panel.setScaling(ScaleOptions.DOWN);
        Rectangle monitorBounds = frame.getGraphicsConfiguration().getBounds();
        if (monitorBounds.width < img.getWidth() || monitorBounds.height < img.getHeight()) {
            double scale = Math.min((double)monitorBounds.width / (double)img.getWidth(), (double)monitorBounds.height / (double)img.getHeight());
            int width = (int)(scale * (double)img.getWidth());
            int height = (int)(scale * (double)img.getHeight());
            panel.setPreferredSize(new Dimension(width, height));
        }
        frame.add((Component)panel, "Center");
        frame.pack();
        ShowImages.setFrameLocation(frame);
        frame.setVisible(true);
        if (closeOnExit) {
            frame.setDefaultCloseOperation(3);
        }
        return panel;
    }

    public static ImagePanel showWindow(ImageBase<?> img, String title) {
        BufferedImage buff = ConvertBufferedImage.convertTo(img, null, (boolean)true);
        return ShowImages.showWindow(buff, title);
    }

    public static void showBlocking(ImageBase<?> img, String title, long milliseconds) {
        ShowImages.showBlocking(img, title, milliseconds, false);
    }

    public static void showBlocking(ImageBase<?> img, String title, long milliseconds, boolean closeOnExit) {
        BufferedImage buff = ConvertBufferedImage.convertTo(img, null, (boolean)true);
        ImagePanel panel = ShowImages.showWindow(buff, title, closeOnExit);
        BoofMiscOps.sleep((long)milliseconds);
        SwingUtilities.invokeLater(() -> {
            JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(panel);
            topFrame.setVisible(false);
            topFrame.dispose();
        });
    }

    public static void showBlocking(JComponent component, String title, long milliseconds) {
        JFrame frame = ShowImages.showWindow(component, title);
        BoofMiscOps.sleep((long)milliseconds);
        SwingUtilities.invokeLater(() -> {
            frame.setVisible(false);
            frame.dispose();
        });
    }

    public static JFrame showWindow(JComponent component, String title) {
        return ShowImages.showWindow(component, title, false);
    }

    public static JFrame showWindow(JComponent component, String title, boolean closeOnExit) {
        JFrame frame = new JFrame(title);
        frame.add((Component)component, "Center");
        SwingUtilities.invokeLater(() -> {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            frame.pack();
            ShowImages.setFrameLocation(frame);
            int width = frame.getWidth();
            int height = frame.getHeight();
            if (width > screenSize.width || height > screenSize.height) {
                width = Math.min(width, screenSize.width);
                height = Math.min(height, screenSize.height);
                frame.setSize(width, height);
            }
            frame.setVisible(true);
            if (closeOnExit) {
                frame.setDefaultCloseOperation(3);
            }
        });
        return frame;
    }

    public static JFrame setupWindow(JComponent component, String title, boolean closeOnExit) {
        BoofSwingUtil.checkGuiThread();
        JFrame frame = new JFrame(title);
        frame.add((Component)component, "Center");
        frame.pack();
        ShowImages.setFrameLocation(frame);
        if (closeOnExit) {
            frame.setDefaultCloseOperation(3);
        }
        return frame;
    }

    private static void setFrameLocation(JFrame frame) {
        frame.setLocationByPlatform(true);
    }

    public static ImagePanel showWindow(ImageGray<?> img, Colorization type, String title, boolean closeOnExit) {
        BufferedImage bufferedImage;
        double max = GImageStatistics.maxAbs(img);
        switch (type) {
            case MAGNITUDE: {
                bufferedImage = VisualizeImageData.grayMagnitude(img, null, max);
                break;
            }
            case SIGN: {
                bufferedImage = VisualizeImageData.colorizeSign(img, null, max);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type. " + String.valueOf((Object)type));
            }
        }
        BufferedImage buff = bufferedImage;
        return ShowImages.showWindow(buff, title, closeOnExit);
    }

    public static enum Colorization {
        MAGNITUDE,
        SIGN;

    }
}

