/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.mesh;

import boofcv.struct.mesh.VertexMesh;
import boofcv.visualize.RenderMesh;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import org.ddogleg.struct.DogArray;
import org.ejml.data.DMatrixRMaj;

public class MeshColorYawRBNormalG
implements RenderMesh.SurfaceColor {
    protected VertexMesh mesh;
    protected int[] colors;
    protected int[] red;
    protected int[] blue;
    protected boolean useGlobal;

    public MeshColorYawRBNormalG(VertexMesh mesh, boolean useGlobal) {
        this.mesh = mesh;
        this.useGlobal = useGlobal;
        this.colors = new int[mesh.size()];
        this.red = new int[361];
        this.blue = new int[361];
        int half = 127;
        int diff = 255 - half;
        for (int degree = 0; degree < this.red.length; ++degree) {
            double yaw = (double)degree * Math.PI / 180.0;
            this.red[degree] = (int)(Math.sin(yaw) * (double)half + (double)diff);
            this.blue[degree] = (int)(Math.sin(yaw + 4.1887902047863905) * (double)half + (double)diff);
        }
        if (useGlobal) {
            this.apply(new Se3_F64());
        }
    }

    public void setWorldToView(Se3_F64 worldToCamera) {
        if (!this.useGlobal) {
            this.apply(worldToCamera);
        }
    }

    public void apply(Se3_F64 worldToCamera) {
        DogArray facet = new DogArray(Point3D_F64::new);
        Vector3D_F64 va = new Vector3D_F64();
        Vector3D_F64 vb = new Vector3D_F64();
        Vector3D_F64 normal = new Vector3D_F64();
        Vector3D_F64 axisZ = new Vector3D_F64(0.0, 0.0, 1.0);
        for (int i = 0; i < this.mesh.size(); ++i) {
            this.mesh.getFaceVectors(i, facet);
            if (facet.size < 3) {
                this.colors[i] = -65536;
                continue;
            }
            va.minus((Point3D_F64)facet.get(1), (Point3D_F64)facet.get(0));
            vb.minus((Point3D_F64)facet.get(2), (Point3D_F64)facet.get(0));
            normal.crossSetTo(va, vb);
            GeometryMath_F64.mult((DMatrixRMaj)worldToCamera.R, (GeoTuple3D_F64)normal, (GeoTuple3D_F64)normal);
            double dot = normal.dot(axisZ);
            double yaw = Math.atan2(normal.y, normal.x);
            int iyaw = (int)(360.0 * (yaw + Math.PI) / (Math.PI * 2));
            int idot = (int)((dot /= normal.norm()) * dot * 256.0) % 256;
            this.colors[i] = 0xFF000000 | this.red[iyaw] << 16 | idot << 8 | this.blue[iyaw];
        }
    }

    public int surfaceRgb(int i) {
        return this.colors[i];
    }
}

