/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.mesh;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.CameraPinhole;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.metric.UtilAngle;
import georegression.struct.EulerType;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DMatrixRMaj;

public class OrbitAroundPoint {
    CameraPinhole camera = new CameraPinhole();
    Se3_F64 worldToView = new Se3_F64();
    private Point3D_F64 targetWorld = new Point3D_F64();
    Point2D_F64 norm1 = new Point2D_F64();
    Point2D_F64 norm2 = new Point2D_F64();
    Point3D_F64 targetInView = new Point3D_F64();
    Point3D_F64 targetInOld = new Point3D_F64();
    Se3_F64 viewToPoint = new Se3_F64();
    Se3_F64 viewToPoint2 = new Se3_F64();
    Se3_F64 worldToPoint = new Se3_F64();
    Se3_F64 pointToRot = new Se3_F64();
    Se3_F64 oldToNew = new Se3_F64();

    public OrbitAroundPoint() {
        this.resetView();
    }

    public void setTarget(double x, double y, double z) {
        this.targetWorld.setTo(x, y, z);
        this.updateAfterExternalChange();
    }

    public void resetView() {
        this.worldToView.reset();
        this.updateAfterExternalChange();
    }

    private void updateAfterExternalChange() {
        if (Math.abs(this.worldToView.T.distance((GeoTuple3D_F64)this.targetWorld)) < 1.0E-16) {
            this.worldToView.T.z += 0.1;
        }
        this.pointAtTarget();
    }

    private void pointAtTarget() {
        this.oldToNew.reset();
        this.worldToView.transform(this.targetWorld, this.targetInView);
        PerspectiveOps.pointAt((double)this.targetInView.x, (double)this.targetInView.y, (double)this.targetInView.z, (DMatrixRMaj)this.oldToNew.R);
        Se3_F64 tmp = this.pointToRot;
        this.worldToView.concatInvert(this.oldToNew, tmp);
        this.worldToView.setTo(tmp);
    }

    public void mouseWheel(double ticks, double scale) {
        this.worldToView.transform(this.targetWorld, this.targetInView);
        this.worldToView.T.z += this.targetInView.norm() * 0.02 * ticks * scale;
    }

    public void mouseDragRotate(double x0, double y0, double x1, double y1) {
        if (this.camera.fx == 0.0 || this.camera.fy == 0.0) {
            return;
        }
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x0, (double)y0, (Point2D_F64)this.norm1);
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x1, (double)y1, (Point2D_F64)this.norm2);
        double rotX = UtilAngle.minus((double)Math.atan(this.norm1.x), (double)Math.atan(this.norm2.x));
        double rotY = UtilAngle.minus((double)Math.atan(this.norm1.y), (double)Math.atan(this.norm2.y));
        this.applyLocalEuler(rotX, -rotY, 0.0);
    }

    private void applyLocalEuler(double rotX, double rotY, double rotZ) {
        this.pointToRot.reset();
        this.worldToView.transform(this.targetWorld, this.targetInOld);
        this.viewToPoint.T.setTo(-this.targetInOld.x, -this.targetInOld.y, -this.targetInOld.z);
        this.worldToView.concat(this.viewToPoint, this.worldToPoint);
        ConvertRotation3D_F64.eulerToMatrix((EulerType)EulerType.XYZ, (double)rotY, (double)rotX, (double)rotZ, (DMatrixRMaj)this.pointToRot.R);
        this.viewToPoint.concat(this.pointToRot, this.viewToPoint2);
        this.worldToPoint.concatInvert(this.viewToPoint2, this.worldToView);
        this.pointAtTarget();
    }

    public void mouseDragZoomRoll(double x0, double y0, double x1, double y1) {
        if (this.camera.fx == 0.0 || this.camera.fy == 0.0) {
            return;
        }
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x0, (double)y0, (Point2D_F64)this.norm1);
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x1, (double)y1, (Point2D_F64)this.norm2);
        this.worldToView.transform(this.targetWorld, this.targetInView);
        this.worldToView.T.z += (this.norm2.y - this.norm1.y) * this.targetInView.norm();
        double rotX = UtilAngle.minus((double)Math.atan(this.norm1.x), (double)Math.atan(this.norm2.x));
        this.applyLocalEuler(0.0, 0.0, rotX);
    }

    public CameraPinhole getCamera() {
        return this.camera;
    }
}

