/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.dialogs;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.dialogs.JSpringPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.DefaultCaret;
import org.jetbrains.annotations.Nullable;

public class FileBrowser
extends JSpringPanel {
    JTextArea textFileName;
    JComboBox<String> comboPath;
    JList<File> fileList;
    DefaultListModel<File> listModel = new DefaultListModel();
    List<File> directories = new ArrayList<File>();
    SortDirectoryFirst sorter = new SortDirectoryFirst();
    ActionListener directoryListener;
    Listener listener;
    List<FileFilter> filters = new ArrayList<FileFilter>();

    public FileBrowser(File directory, @Nullable JTextArea providedFileName, final Listener listener) {
        this.listener = listener;
        directory = directory.getAbsoluteFile();
        if (directory.isDirectory() && directory.getName().equals(".")) {
            directory = directory.getParentFile();
        }
        if (providedFileName == null) {
            this.textFileName = new JTextArea();
            DefaultCaret caret = (DefaultCaret)this.textFileName.getCaret();
            caret.setUpdatePolicy(2);
            this.textFileName.setRows(1);
            this.textFileName.setEditable(false);
            this.textFileName.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        } else {
            this.textFileName = providedFileName;
        }
        this.comboPath = new JComboBox();
        this.fileList = new JList<File>(this.listModel);
        this.fileList.setCellRenderer(new FileListCellRenderer());
        this.fileList.setSelectionMode(0);
        this.fileList.setLayoutOrientation(0);
        this.fileList.addListSelectionListener(new FileSelectionListener(this));
        this.fileList.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FileBrowser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    File selected = this.this$0.listModel.get(this.this$0.fileList.getSelectedIndex());
                    if (selected.isDirectory()) {
                        this.this$0.setDirectory(selected);
                    } else {
                        this.this$0.setSelectedName(selected);
                        listener.handleDoubleClickedFile(selected);
                    }
                }
            }
        });
        JScrollPane scrollList = new JScrollPane(this.fileList);
        scrollList.setVerticalScrollBarPolicy(22);
        JPanel navigationPanel = this.createNavigationPanel();
        JPanel directoryRow = new JPanel();
        directoryRow.setLayout(new BoxLayout(directoryRow, 0));
        directoryRow.add(new JLabel("Location"));
        directoryRow.add(Box.createHorizontalStrut(5));
        directoryRow.add(this.comboPath);
        if (providedFileName == null) {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            JScrollPane nameScrollPane = new JScrollPane(this.textFileName);
            nameScrollPane.setHorizontalScrollBarPolicy(31);
            nameScrollPane.setVerticalScrollBarPolicy(21);
            panel.add(new JLabel("Name"));
            panel.add(Box.createHorizontalStrut(5));
            panel.add(nameScrollPane);
            this.constrainWestNorthEast(panel, null, 5, 5);
            this.constrainWestNorthEast(directoryRow, panel, 5, 5);
        } else {
            this.constrainWestNorthEast(directoryRow, null, 5, 5);
        }
        this.constrainWestNorthEast(navigationPanel, directoryRow, 5, 5);
        this.constrainWestNorthEast(scrollList, navigationPanel, 5, 5);
        this.layout.putConstraint("South", (Component)scrollList, -5, "South", (Component)this);
        this.setDirectory(directory);
        this.directoryListener = e -> {
            if (this.comboPath.getSelectedIndex() >= 0) {
                File f = this.directories.get(this.comboPath.getSelectedIndex());
                this.setDirectory(f);
            }
        };
        this.comboPath.addActionListener(this.directoryListener);
    }

    public void addFileFilter(FileFilter filter) {
        this.filters.add(filter);
    }

    public void setSelectedFile(File file) {
        if (file.isDirectory()) {
            this.setDirectory(file);
        } else {
            this.setDirectory(file.getParentFile());
            for (int i = 0; i < this.listModel.size(); ++i) {
                File f = this.listModel.get(i);
                if (!f.getName().equals(file.getName())) continue;
                this.fileList.setSelectedIndex(i);
                this.fileList.ensureIndexIsVisible(i);
                this.setSelectedName(file);
                return;
            }
        }
    }

    public void setSelectionMode(int mode) {
        this.fileList.setSelectionMode(mode);
    }

    private JPanel createNavigationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JButton bHome = BoofSwingUtil.createButtonIconGUI("Home24.gif", 26, 26);
        bHome.setToolTipText("User Home");
        bHome.addActionListener(e -> this.setDirectory(BoofSwingUtil.directoryUserHome()));
        JButton bSystem = BoofSwingUtil.createButtonIconGUI("Host24.gif", 26, 26);
        bSystem.setToolTipText("System");
        bSystem.addActionListener(e -> this.setDirectory(null));
        JButton bPrevious = BoofSwingUtil.createButtonIconGUI("AlignCenter24.gif", 26, 26);
        bPrevious.setToolTipText("Previous");
        JButton bUp = BoofSwingUtil.createButtonIconGUI("Up24.gif", 26, 26);
        bUp.setToolTipText("Up Directory");
        bUp.addActionListener(e -> {
            if (this.directories.isEmpty()) {
                return;
            }
            File d = this.directories.get(this.directories.size() - 1);
            this.setDirectory(d.getParentFile());
        });
        panel.add(Box.createHorizontalGlue());
        panel.add(bHome);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(bSystem);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(bPrevious);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(bUp);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private void setSelectedName(File file) {
        this.textFileName.setText(file.getName());
    }

    public void setDirectory(@Nullable File file) {
        ArrayList<File> roots = null;
        if (file == null) {
            roots = new ArrayList<File>(Arrays.asList(File.listRoots()));
            for (int i = roots.size() - 1; i >= 0; --i) {
                File[] files = ((File)roots.get(i)).listFiles();
                if (files != null && files.length != 0) continue;
                roots.remove(i);
            }
            if (roots.size() == 1) {
                file = (File)roots.get(0);
                roots = null;
            }
        }
        if (roots == null) {
            this.setDirectoryNormal(Objects.requireNonNull(file));
        } else {
            this.textFileName.setText("");
            this.listModel.clear();
            for (File f : roots) {
                this.listModel.addElement(f);
            }
            this.comboPath.removeActionListener(this.directoryListener);
            this.comboPath.removeAllItems();
            this.comboPath.addActionListener(this.directoryListener);
            this.listener.handleSelectedFile(null);
        }
    }

    private void setDirectoryNormal(File file) {
        if (file.isFile()) {
            this.textFileName.setText(file.getName());
        } else {
            this.textFileName.setText("");
        }
        this.listModel.clear();
        List<File> files = this.filterChildren(file);
        files.sort(this.sorter);
        for (File f : files) {
            if (f.isHidden()) continue;
            this.listModel.addElement(f);
        }
        if ((file = file.getAbsoluteFile()).isFile()) {
            file = file.getParentFile();
        }
        files = new ArrayList<File>();
        while (file != null) {
            files.add(file);
            file = file.getParentFile();
        }
        this.comboPath.removeActionListener(this.directoryListener);
        this.comboPath.removeAllItems();
        this.directories.clear();
        for (int i = files.size() - 1; i >= 0; --i) {
            File f;
            f = files.get(i);
            if (f.getParentFile() == null) {
                try {
                    this.comboPath.addItem(f.getCanonicalPath());
                }
                catch (IOException e) {
                    this.comboPath.addItem("/");
                }
            } else {
                this.comboPath.addItem(files.get(i).getName());
            }
            this.directories.add(f);
        }
        this.comboPath.setSelectedIndex(files.size() - 1);
        this.comboPath.addActionListener(this.directoryListener);
        this.listener.handleSelectedFile(null);
    }

    private List<File> filterChildren(File file) {
        File[] fileArray = file.listFiles();
        ArrayList<File> files = new ArrayList<File>();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                boolean filtered;
                File f = fileArray[i];
                if (f.isDirectory()) {
                    filtered = false;
                } else {
                    filtered = this.filters.size() > 0;
                    for (int j = 0; j < this.filters.size(); ++j) {
                        if (!this.filters.get(j).accept(f)) continue;
                        filtered = false;
                        break;
                    }
                }
                if (filtered) continue;
                files.add(f);
            }
        }
        return files;
    }

    public List<File> getSelectedFiles() {
        List<File> selected = this.fileList.getSelectedValuesList();
        return new ArrayList<File>(selected);
    }

    private static class SortDirectoryFirst
    implements Comparator<File> {
        private SortDirectoryFirst() {
        }

        @Override
        public int compare(File a, File b) {
            if (a.isDirectory()) {
                if (b.isDirectory()) {
                    return a.getName().compareToIgnoreCase(b.getName());
                }
                return -1;
            }
            if (b.isDirectory()) {
                return 1;
            }
            return a.getName().compareToIgnoreCase(b.getName());
        }
    }

    public static interface Listener {
        public void handleSelectedFile(@Nullable File var1);

        public void handleDoubleClickedFile(File var1);
    }

    private static class FileListCellRenderer
    extends DefaultListCellRenderer {
        private FileSystemView fileSystemView;
        private JLabel label = new JLabel();
        private Color textSelectionColor;
        private Color backgroundSelectionColor;
        private Color textNonSelectionColor;
        private Color backgroundNonSelectionColor;

        FileListCellRenderer() {
            this.label.setBorder(new EmptyBorder(2, 4, 2, 4));
            this.label.setOpaque(true);
            this.fileSystemView = FileSystemView.getFileSystemView();
            UIDefaults defaults = UIManager.getDefaults();
            this.backgroundSelectionColor = defaults.getColor("List.selectionBackground");
            this.textSelectionColor = defaults.getColor("List.selectionForeground");
            this.backgroundNonSelectionColor = defaults.getColor("List.background");
            this.textNonSelectionColor = defaults.getColor("List.foreground");
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean expanded) {
            File file = (File)value;
            String name = this.fileSystemView.getSystemDisplayName(file);
            if (name.length() == 0) {
                name = file.getAbsolutePath();
            }
            this.label.setIcon(this.fileSystemView.getSystemIcon(file));
            this.label.setText(name);
            this.label.setToolTipText(file.getPath());
            if (selected) {
                this.label.setBackground(this.backgroundSelectionColor);
                this.label.setForeground(this.textSelectionColor);
            } else {
                this.label.setBackground(this.backgroundNonSelectionColor);
                this.label.setForeground(this.textNonSelectionColor);
            }
            return this.label;
        }
    }

    private class FileSelectionListener
    implements ListSelectionListener {
        FileBrowser browser;

        FileSelectionListener(FileBrowser browser) {
            this.browser = browser;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            JList fileList = (JList)e.getSource();
            DefaultListModel listModel = (DefaultListModel)fileList.getModel();
            int index = fileList.getSelectedIndex();
            if (index >= 0) {
                File f = (File)listModel.getElementAt(index);
                this.browser.setSelectedName(f);
                FileBrowser.this.listener.handleSelectedFile(f);
            } else {
                FileBrowser.this.listener.handleSelectedFile(null);
            }
        }
    }
}

