/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.learning;

import boofcv.gui.image.ShowImages;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JPanel;
import lombok.Generated;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.RandomMatrices_DDRM;

public class ConfusionMatrixPanel
extends JPanel {
    DMatrixRMaj temp = new DMatrixRMaj(1, 1);
    DMatrixRMaj confusion = new DMatrixRMaj(1, 1);
    boolean dirty = false;
    boolean gray = false;
    boolean showNumbers = true;
    boolean showLabels = true;
    boolean showZeros = true;
    double labelViewFraction = 0.3;
    List<String> labels;
    int highlightCategory = -1;
    int viewHeight;
    int viewWidth;
    int gridHeight;
    int gridWidth;
    boolean renderLabels;

    public ConfusionMatrixPanel(DMatrixRMaj M, List<String> labels, int widthPixels, boolean gray) {
        this(widthPixels, labels != null);
        this.setLabels(labels);
        this.setMatrix(M);
        this.gray = gray;
    }

    public ConfusionMatrixPanel(int widthPixels, boolean hasLabels) {
        int heightPixels = widthPixels;
        if (hasLabels) {
            heightPixels = (int)((double)heightPixels * (1.0 - this.labelViewFraction));
        }
        this.setPreferredSize(new Dimension(widthPixels, heightPixels));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatrix(DMatrixRMaj A) {
        ConfusionMatrixPanel confusionMatrixPanel = this;
        synchronized (confusionMatrixPanel) {
            this.temp.setTo((DMatrixD1)A);
            this.dirty = true;
        }
        this.repaint();
    }

    public void setLabels(List<String> labels) {
        this.labels = new ArrayList<String>(labels);
    }

    public int getHighlightCategory() {
        return this.highlightCategory;
    }

    public void setHighlightCategory(int highlightCategory) {
        this.highlightCategory = highlightCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void paint(Graphics g) {
        ConfusionMatrixPanel confusionMatrixPanel = this;
        synchronized (confusionMatrixPanel) {
            if (this.dirty) {
                this.confusion.setTo((DMatrixD1)this.temp);
                this.dirty = false;
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        int numCategories = this.confusion.getNumRows();
        ConfusionMatrixPanel confusionMatrixPanel2 = this;
        synchronized (confusionMatrixPanel2) {
            this.viewHeight = this.getHeight();
            this.viewWidth = this.getWidth();
            this.gridHeight = this.viewHeight;
            this.gridWidth = this.viewWidth;
            boolean bl = this.renderLabels = this.showLabels && this.labels != null;
            if (this.renderLabels) {
                this.gridWidth = (int)((double)this.gridWidth * (1.0 - this.labelViewFraction));
            }
        }
        double fontSize = Math.min(this.gridWidth / numCategories, this.gridHeight / numCategories);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.renderLabels) {
            this.renderLabels(g2, fontSize);
        }
        this.renderMatrix(g2, fontSize);
        if (this.highlightCategory >= 0 && this.highlightCategory < numCategories) {
            g2.setColor(new Color(255, 255, 0, 100));
            int ry = (int)(0.1 * (double)this.gridHeight / (double)numCategories);
            int rx = (int)(0.1 * (double)this.gridWidth / (double)numCategories);
            int y0 = this.highlightCategory * this.gridHeight / numCategories;
            int y1 = (this.highlightCategory + 1) * this.gridHeight / numCategories;
            int x0 = this.highlightCategory * this.gridWidth / numCategories;
            int x1 = (this.highlightCategory + 1) * this.gridWidth / numCategories;
            g2.fillRect(x0 + rx, 0, x1 - x0 - 2 * rx, this.gridHeight);
            g2.fillRect(0, y0 + ry, this.viewWidth, y1 - y0 - 2 * ry);
        }
    }

    private void renderLabels(Graphics2D g2, double fontSize) {
        int numCategories = this.confusion.getNumRows();
        int longestLabel = 0;
        if (this.renderLabels) {
            for (int i = 0; i < numCategories; ++i) {
                longestLabel = Math.max(longestLabel, this.labels.get(i).length());
            }
        }
        Font fontLabel = new Font("monospaced", 1, (int)(0.055 * (double)longestLabel * fontSize + 0.5));
        g2.setFont(fontLabel);
        FontMetrics metrics = g2.getFontMetrics(fontLabel);
        g2.setColor(Color.WHITE);
        g2.fillRect(this.gridWidth, 0, this.viewWidth - this.gridWidth, this.viewHeight);
        g2.setColor(Color.BLACK);
        for (int i = 0; i < numCategories; ++i) {
            String label = this.labels.get(i);
            int y0 = i * this.gridHeight / numCategories;
            int y1 = (i + 1) * this.gridHeight / numCategories;
            Rectangle2D r = metrics.getStringBounds(label, null);
            float adjX = (float)(r.getX() * 2.0 + r.getWidth()) / 2.0f;
            float adjY = (float)(r.getY() * 2.0 + r.getHeight()) / 2.0f;
            float x = (float)(this.viewWidth + this.gridWidth) / 2.0f - adjX;
            float y = (float)(y1 + y0) / 2.0f - adjY;
            g2.drawString(label, x, y);
        }
    }

    private void renderMatrix(Graphics2D g2, double fontSize) {
        int numCategories = this.confusion.getNumRows();
        Font fontNumber = new Font("Serif", 1, (int)(0.6 * fontSize + 0.5));
        g2.setFont(fontNumber);
        FontMetrics metrics = g2.getFontMetrics(fontNumber);
        for (int i = 0; i < numCategories; ++i) {
            int y0 = i * this.gridHeight / numCategories;
            int y1 = (i + 1) * this.gridHeight / numCategories;
            for (int j = 0; j < numCategories; ++j) {
                int red;
                int green;
                int blue;
                int x0 = j * this.gridWidth / numCategories;
                int x1 = (j + 1) * this.gridWidth / numCategories;
                double value = this.confusion.unsafe_get(i, j);
                if (this.gray) {
                    green = blue = (int)(255.0 * (1.0 - value));
                    red = blue;
                } else {
                    green = 0;
                    red = (int)(255.0 * value);
                    blue = (int)(255.0 * (1.0 - value));
                }
                g2.setColor(new Color(red, green, blue));
                g2.fillRect(x0, y0, x1 - x0, y1 - y0);
                if (!this.showNumbers || !this.showZeros && value == 0.0) continue;
                int a = (red + green + blue) / 3;
                String text = "" + (int)(value * 100.0 + 0.5);
                Rectangle2D r = metrics.getStringBounds(text, null);
                float adjX = (float)(r.getX() * 2.0 + r.getWidth()) / 2.0f;
                float adjY = (float)(r.getY() * 2.0 + r.getHeight()) / 2.0f;
                float x = (float)(x1 + x0) / 2.0f - adjX;
                float y = (float)(y1 + y0) / 2.0f - adjY;
                int gray = a > 127 ? 0 : 255;
                g2.setColor(new Color(gray, gray, gray));
                g2.drawString(text, x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationInfo whatIsAtPoint(int pixelX, int pixelY, LocationInfo output) {
        if (output == null) {
            output = new LocationInfo();
        }
        int numCategories = this.confusion.getNumRows();
        ConfusionMatrixPanel confusionMatrixPanel = this;
        synchronized (confusionMatrixPanel) {
            if (pixelX >= this.gridWidth) {
                output.insideMatrix = false;
                output.col = output.row = pixelY * numCategories / this.gridHeight;
            } else {
                output.insideMatrix = true;
                output.row = pixelY * numCategories / this.gridHeight;
                output.col = pixelX * numCategories / this.gridWidth;
            }
        }
        return output;
    }

    public static void main(String[] args) {
        DMatrixRMaj m = RandomMatrices_DDRM.rectangle((int)5, (int)5, (double)0.0, (double)1.0, (Random)new Random(234L));
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < m.numRows; ++i) {
            labels.add("Label " + i);
        }
        ConfusionMatrixPanel confusion = new ConfusionMatrixPanel(m, labels, 300, false);
        confusion.setHighlightCategory(2);
        ShowImages.showWindow(confusion, "Window", true);
    }

    @Generated
    public boolean isGray() {
        return this.gray;
    }

    @Generated
    public void setGray(boolean gray) {
        this.gray = gray;
    }

    @Generated
    public boolean isShowNumbers() {
        return this.showNumbers;
    }

    @Generated
    public void setShowNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    @Generated
    public boolean isShowLabels() {
        return this.showLabels;
    }

    @Generated
    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    @Generated
    public boolean isShowZeros() {
        return this.showZeros;
    }

    @Generated
    public void setShowZeros(boolean showZeros) {
        this.showZeros = showZeros;
    }

    public static class LocationInfo {
        public boolean insideMatrix;
        public int row;
        public int col;
    }
}

