/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.mesh;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.CameraPinhole;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.metric.UtilAngle;
import georegression.struct.EulerType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import lombok.Generated;
import org.ejml.data.DMatrixRMaj;

public class FirstPersonShooterCamera {
    CameraPinhole camera = new CameraPinhole();
    final Se3_F64 worldToView = new Se3_F64();
    final Se3_F64 mouseMotion = new Se3_F64();
    public double motionUnit;
    Point2D_F64 norm1 = new Point2D_F64();
    Point2D_F64 norm2 = new Point2D_F64();
    final Se3_F64 tmp = new Se3_F64();

    public void resetView() {
        this.worldToView.reset();
    }

    public void translateKey(int dx, int dy, int dz, double scale) {
        this.worldToView.T.x += (double)dx * this.motionUnit * scale;
        this.worldToView.T.y += (double)dy * this.motionUnit * scale;
        this.worldToView.T.z += (double)dz * this.motionUnit * scale;
    }

    public void mouseDragPanTilt(double x0, double y0, double x1, double y1) {
        if (!this.isCameraConfigured()) {
            return;
        }
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x0, (double)y0, (Point2D_F64)this.norm1);
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x1, (double)y1, (Point2D_F64)this.norm2);
        double rotX = UtilAngle.minus((double)Math.atan(this.norm1.x), (double)Math.atan(this.norm2.x));
        double rotY = UtilAngle.minus((double)Math.atan(this.norm1.y), (double)Math.atan(this.norm2.y));
        ConvertRotation3D_F64.eulerToMatrix((EulerType)EulerType.XYZ, (double)rotY, (double)(-rotX), (double)0.0, (DMatrixRMaj)this.mouseMotion.R);
        this.worldToView.concat(this.mouseMotion, this.tmp);
        this.worldToView.setTo(this.tmp);
    }

    public void mouseDragRoll(double x0, double y0, double x1, double y1) {
        if (!this.isCameraConfigured()) {
            return;
        }
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x0, (double)y0, (Point2D_F64)this.norm1);
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x1, (double)y1, (Point2D_F64)this.norm2);
        double angle0 = Math.atan2(this.norm1.y, this.norm1.x);
        double angle1 = Math.atan2(this.norm2.y, this.norm2.x);
        double rotZ = angle1 - angle0;
        ConvertRotation3D_F64.eulerToMatrix((EulerType)EulerType.XYZ, (double)0.0, (double)0.0, (double)rotZ, (DMatrixRMaj)this.mouseMotion.R);
        this.worldToView.concat(this.mouseMotion, this.tmp);
        this.worldToView.setTo(this.tmp);
    }

    private boolean isCameraConfigured() {
        return this.camera.fx != 0.0 && this.camera.fy != 0.0;
    }

    @Generated
    public CameraPinhole getCamera() {
        return this.camera;
    }
}

