/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.mesh;

import boofcv.gui.mesh.MeshColorYawRBNormalG;
import boofcv.struct.mesh.VertexMesh;
import boofcv.visualize.RenderMesh;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import org.ddogleg.struct.DogArray;

public class MeshColorizeOps {
    public static RenderMesh.SurfaceColor colorizeByVertex(VertexMesh mesh, int[] vertexColor) {
        return shapeIdx -> vertexColor[mesh.faceVertexes.get(mesh.faceOffsets.get(shapeIdx))];
    }

    public static RenderMesh.SurfaceColor colorizeByNormal(VertexMesh mesh) {
        int[] colors = new int[mesh.size()];
        DogArray facet = new DogArray(Point3D_F64::new);
        Vector3D_F64 va = new Vector3D_F64();
        Vector3D_F64 vb = new Vector3D_F64();
        Vector3D_F64 normal = new Vector3D_F64();
        Vector3D_F64 axisZ = new Vector3D_F64(0.0, 0.0, 1.0);
        for (int i = 0; i < mesh.size(); ++i) {
            mesh.getFaceVectors(i, facet);
            if (facet.size < 3) {
                colors[i] = -65536;
                continue;
            }
            va.minus((Point3D_F64)facet.get(1), (Point3D_F64)facet.get(0));
            vb.minus((Point3D_F64)facet.get(2), (Point3D_F64)facet.get(0));
            normal.crossSetTo(va, vb);
            double dot = normal.dot(axisZ);
            int green = (int)((dot /= normal.norm()) * dot * 256.0) % 256;
            colors[i] = 0xFF000000 | green << 8;
        }
        return index -> colors[index];
    }

    public static RenderMesh.SurfaceColor colorizeYawRBNormG(VertexMesh mesh, boolean global) {
        return new MeshColorYawRBNormalG(mesh, global);
    }
}

