/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.mesh;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.pinhole.LensDistortionPinhole;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.gui.BoofSwingUtil;
import boofcv.gui.image.SaveImageOnClick;
import boofcv.gui.image.VisualizeImageData;
import boofcv.gui.mesh.FirstPersonCameraControl;
import boofcv.gui.mesh.MeshColorizeOps;
import boofcv.gui.mesh.MeshViewerPreferencePanel;
import boofcv.gui.mesh.OrbitAroundPointControl;
import boofcv.gui.mesh.Swing3dCameraControl;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.mesh.VertexMesh;
import boofcv.visualize.RenderMesh;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lombok.Generated;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public class MeshViewerPanel
extends JPanel
implements VerbosePrint,
KeyEventDispatcher {
    public static final String COLOR_NORMAL = "Normal";
    public int buttonSize = 60;
    public Font helpButtonFont = new Font("Serif", 1, 45);
    public boolean helpButtonActive = true;
    RenderMesh renderer = new RenderMesh();
    VertexMesh mesh = new VertexMesh();
    ReentrantLock lockSwap = new ReentrantLock();
    BufferedImage buffered = new BufferedImage(1, 1, 1);
    BufferedImage work = new BufferedImage(1, 1, 1);
    boolean shutdownRequested = false;
    boolean renderRequested = false;
    boolean cameraInitialized = false;
    Thread renderThread = new Thread(this::renderLoop, "MeshRender");
    final ImageDimension dimension = new ImageDimension();
    double hfov = 90.0;
    boolean showDepth = false;
    final Map<String, Swing3dCameraControl> controls = new HashMap<String, Swing3dCameraControl>();
    String lastControlName = "";
    Se3_F64 recentWorldToView = new Se3_F64();
    @Nullable
    Swing3dCameraControl activeControl;
    final Map<String, RenderMesh.SurfaceColor> colorizers = new HashMap<String, RenderMesh.SurfaceColor>();
    final List<String> colorizerNames = new ArrayList<String>();
    int activeColorizer;
    GrayF32 inverseDepth = new GrayF32(1, 1);
    @Nullable
    JFrame helpWindow;
    @Nullable
    PrintStream verbose = null;
    CustomPaint customPaint = g2 -> {};
    CameraChanged cameraChanged = cam -> {};
    CameraPinhole intrinsics = new CameraPinhole();
    long coolDownTime = 0L;

    public MeshViewerPanel(VertexMesh mesh) {
        this();
        this.setMesh(mesh, false);
    }

    public MeshViewerPanel() {
        this.addMouseListener(new SaveImageOnClick(this));
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent e) {
                ImageDimension imageDimension = MeshViewerPanel.this.dimension;
                synchronized (imageDimension) {
                    MeshViewerPanel.this.dimension.width = MeshViewerPanel.this.getWidth();
                    MeshViewerPanel.this.dimension.height = MeshViewerPanel.this.getHeight();
                    MeshViewerPanel.this.requestRender();
                    MeshViewerPanel.this.cameraChanged.cameraChanged(MeshViewerPanel.this.getIntrinsicsCopy());
                }
            }
        });
        this.controls.put("Orbit", new OrbitAroundPointControl());
        this.controls.put("FPS", new FirstPersonCameraControl());
        this.setActiveControl("Orbit");
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(MeshViewerPanel.this);
            }

            @Override
            public void focusLost(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(MeshViewerPanel.this);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MeshViewerPanel.this.requestFocus();
                if (!MeshViewerPanel.this.helpButtonActive || e.getX() >= MeshViewerPanel.this.buttonSize || e.getY() >= MeshViewerPanel.this.buttonSize) {
                    return;
                }
                if (MeshViewerPanel.this.helpWindow == null) {
                    MeshViewerPanel.this.showHelpWindow();
                }
            }
        });
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(500, 500));
    }

    public float imagePixelToDepthZ(int pixelX, int pixelY) {
        GrayF32 depth = this.renderer.depthImage;
        if (!depth.isInBounds(pixelX, pixelY)) {
            return Float.NaN;
        }
        return depth.unsafe_get(pixelX, pixelY);
    }

    public boolean imagePixelToCamera3D(int pixelX, int pixelY, Point2D_F64 norm, Point3D_F64 p3) {
        GrayF32 depth = this.renderer.depthImage;
        if (!depth.isInBounds(pixelX, pixelY)) {
            return false;
        }
        float d = depth.unsafe_get(pixelX, pixelY);
        if (Float.isNaN(d) || d <= 0.0f) {
            return false;
        }
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.intrinsics, (double)pixelX, (double)pixelY, (Point2D_F64)norm);
        p3.z = d;
        p3.x = norm.x * p3.z;
        p3.y = norm.y * p3.z;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imagePixelToWorld3D(int pixelX, int pixelY, Point2D_F64 norm, Point3D_F64 p3) {
        if (!this.imagePixelToCamera3D(pixelX, pixelY, norm, p3)) {
            return false;
        }
        Se3_F64 worldToCamera = new Se3_F64();
        Map<String, Swing3dCameraControl> map = this.controls;
        synchronized (map) {
            worldToCamera.setTo(this.recentWorldToView);
        }
        worldToCamera.transformReverse(p3, p3);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachCameraFromUI() {
        Map<String, Swing3dCameraControl> map = this.controls;
        synchronized (map) {
            if (this.activeControl == null) {
                return;
            }
            this.activeControl.detachControls(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachCameraToUI() {
        Map<String, Swing3dCameraControl> map = this.controls;
        synchronized (map) {
            if (this.activeControl == null) {
                return;
            }
            this.activeControl.attachControls(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveControl(String name) {
        this.lastControlName = name;
        Map<String, Swing3dCameraControl> map = this.controls;
        synchronized (map) {
            Se3_F64 currentWorldToView = new Se3_F64();
            if (this.activeControl != null) {
                currentWorldToView.setTo(this.activeControl.getWorldToCamera());
                this.activeControl.detachControls(this);
            }
            this.activeControl = Objects.requireNonNull(this.controls.get(name));
            this.activeControl.setChangeHandler(this::requestRender);
            this.activeControl.attachControls(this);
            if (this.mesh != null) {
                this.activeControl.selectInitialParameters(this.mesh);
                this.recentWorldToView.setTo(this.activeControl.getWorldToCamera());
                this.requestRender();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveControl() {
        Map<String, Swing3dCameraControl> map = this.controls;
        synchronized (map) {
            if (this.activeControl != null) {
                this.activeControl.detachControls(this);
            }
            this.activeControl = null;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.helpWindow != null) {
            this.helpWindow.setVisible(false);
            this.helpWindow = null;
        }
        this.shutdownRenderThread();
    }

    public void shutdownRenderThread() {
        this.shutdownRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMesh(VertexMesh mesh, boolean copy) {
        if (copy) {
            mesh = new VertexMesh().setTo(mesh);
        }
        this.cameraInitialized = false;
        this.mesh = mesh;
        this.colorizers.clear();
        this.colorizerNames.clear();
        Map<String, RenderMesh.SurfaceColor> map = this.colorizers;
        synchronized (map) {
            this.setSurfaceColor(COLOR_NORMAL, MeshColorizeOps.colorizeByNormal(mesh));
            this.setSurfaceColor("Global YawRB-NormG", MeshColorizeOps.colorizeYawRBNormG(mesh, true));
            this.setSurfaceColor("Local YawRB-NormG", MeshColorizeOps.colorizeYawRBNormG(mesh, false));
            this.renderer.surfaceColor = Objects.requireNonNull(this.colorizers.get(COLOR_NORMAL));
            this.activeColorizer = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurfaceColor(String name, RenderMesh.SurfaceColor colorizer) {
        Map<String, RenderMesh.SurfaceColor> map = this.colorizers;
        synchronized (map) {
            this.activeColorizer = this.colorizers.size();
            this.colorizers.put(name, colorizer);
            this.colorizerNames.add(name);
            this.renderer.surfaceColor = this.colorizers.get(name);
        }
    }

    public void setVertexColors(String name, int[] vertexColors) {
        if (this.mesh == null) {
            throw new IllegalArgumentException("You must first specify the mesh before calling this function");
        }
        this.setSurfaceColor(name, MeshColorizeOps.colorizeByVertex(this.mesh, vertexColors));
    }

    public void requestRender() {
        this.renderRequested = true;
    }

    private void renderLoop() {
        if (this.verbose != null) {
            this.verbose.println("Starting render loop");
        }
        while (!this.shutdownRequested) {
            if (this.renderRequested) {
                this.renderRequested = false;
                this.render();
            }
            BoofMiscOps.sleep((long)10L);
        }
        if (this.verbose != null) {
            this.verbose.println("Finished render loop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render() {
        Object object = this.dimension;
        synchronized (object) {
            if (this.dimension.width <= 0 || this.dimension.height <= 0) {
                if (this.verbose != null) {
                    this.verbose.println("invalid size");
                }
                return;
            }
            PerspectiveOps.createIntrinsic((int)this.dimension.width, (int)this.dimension.height, (double)this.hfov, (double)-1.0, (CameraPinhole)this.intrinsics);
            LensDistortionPinhole factory = new LensDistortionPinhole(this.intrinsics);
            this.renderer.setCamera((LensDistortionNarrowFOV)factory, this.dimension.width, this.dimension.height);
        }
        object = this.controls;
        synchronized (object) {
            if (this.activeControl != null) {
                this.activeControl.setCamera(this.intrinsics);
                if (!this.cameraInitialized) {
                    this.cameraInitialized = true;
                    this.activeControl.selectInitialParameters(this.mesh);
                }
                this.renderer.setWorldToView(this.activeControl.getWorldToCamera());
                this.renderer.getWorldToView(this.recentWorldToView);
            }
        }
        long time0 = System.currentTimeMillis();
        this.renderer.render(this.mesh);
        long time1 = System.currentTimeMillis();
        try {
            if (this.showDepth) {
                GrayF32 depth = this.renderer.getDepthImage();
                this.inverseDepth.reshapeTo((ImageBase)depth);
                int N = depth.totalPixels();
                for (int i = 0; i < N; ++i) {
                    float d = depth.data[i];
                    this.inverseDepth.data[i] = Float.isNaN(d) || d <= 0.0f ? -1.0f : 1.0f / d;
                }
                this.work = VisualizeImageData.inverseDepth(this.inverseDepth, this.work, 0.0f, -1.0f, 0);
            } else {
                InterleavedU8 rgb = this.renderer.getRgbImage();
                this.work = ConvertBufferedImage.checkDeclare((int)rgb.width, (int)rgb.height, (BufferedImage)this.work, (int)this.work.getType());
                ConvertBufferedImage.convertTo((InterleavedU8)rgb, (BufferedImage)this.work, (boolean)false);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        long time2 = System.currentTimeMillis();
        if (this.verbose != null) {
            this.verbose.printf("render(): %dx%d  mesh: %d (ms) convert: %d (ms)\n", this.dimension.width, this.dimension.height, time1 - time0, time2 - time1);
        }
        this.lockSwap.lock();
        try {
            BufferedImage tmp = this.buffered;
            this.buffered = this.work;
            this.work = tmp;
        }
        finally {
            this.lockSwap.unlock();
        }
        super.repaint();
    }

    public void setHorizontalFov(double degrees) {
        this.hfov = degrees;
        this.requestRender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cycleColorizer() {
        int totalColors = this.colorizers.size();
        if (this.mesh.isTextured()) {
            ++totalColors;
        }
        Map<String, RenderMesh.SurfaceColor> map = this.colorizers;
        synchronized (map) {
            this.activeColorizer = (this.activeColorizer + 1) % totalColors;
            if (this.mesh.isTextured()) {
                if (this.activeColorizer == 0) {
                    this.renderer.forceColorizer = false;
                } else {
                    this.renderer.forceColorizer = true;
                    this.renderer.surfaceColor = Objects.requireNonNull(this.colorizers.get(this.colorizerNames.get(this.activeColorizer - 1)));
                }
            } else {
                this.renderer.surfaceColor = Objects.requireNonNull(this.colorizers.get(this.colorizerNames.get(this.activeColorizer)));
            }
            this.requestRender();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            if (!this.renderThread.isAlive()) {
                this.renderThread.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Graphics2D g2 = (Graphics2D)g;
        BoofSwingUtil.antialiasing(g);
        this.lockSwap.lock();
        try {
            g2.drawImage((Image)this.buffered, 0, 0, null);
        }
        finally {
            this.lockSwap.unlock();
        }
        if (this.helpButtonActive) {
            this.drawHelpButton(g2);
        }
        this.customPaint.paint(g2);
    }

    private void drawHelpButton(Graphics2D g2) {
        String text = "?";
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, this.buttonSize, this.buttonSize);
        g2.setFont(this.helpButtonFont);
        GlyphVector gv = this.helpButtonFont.createGlyphVector(g2.getFontRenderContext(), text);
        Rectangle2D bounds = gv.getVisualBounds();
        g2.setColor(Color.RED);
        float offsetX = (float)(((double)this.buttonSize - bounds.getWidth()) / 2.0);
        float offsetY = (float)(((double)this.buttonSize - bounds.getHeight()) / 2.0 + bounds.getHeight());
        g2.drawString(text, offsetX, offsetY);
    }

    public void showHelpWindow() {
        if (this.helpWindow != null) {
            return;
        }
        this.helpWindow = new JFrame("Mesh Viewer Help");
        this.helpWindow.setLocationRelativeTo(this);
        this.helpWindow.add((Component)new MeshViewerPreferencePanel(this), "Center");
        this.helpWindow.pack();
        this.helpWindow.setAlwaysOnTop(true);
        this.helpWindow.setDefaultCloseOperation(2);
        this.helpWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                MeshViewerPanel.this.helpWindow = null;
            }
        });
        this.helpWindow.setVisible(true);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
        VerboseUtils.verboseChildren((PrintStream)out, configuration, (VerbosePrint[])new VerbosePrint[]{this.renderer});
    }

    public void setRenderBackgroundColor(int rgba) {
        this.renderer.defaultColorRgba = rgba;
    }

    public int getRenderBackgroundColor() {
        return this.renderer.defaultColorRgba;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (System.currentTimeMillis() <= this.coolDownTime) {
            return false;
        }
        if (e.getKeyCode() == 72) {
            if (this.activeControl != null) {
                this.activeControl.reset();
            }
            this.cameraInitialized = false;
            this.requestRender();
        } else if (e.getKeyCode() == 74) {
            this.cycleColorizer();
        } else if (e.getKeyCode() == 75) {
            this.showDepth = !this.showDepth;
            this.requestRender();
        } else {
            return false;
        }
        this.coolDownTime = System.currentTimeMillis() + 200L;
        return false;
    }

    public void setTextureImage(InterleavedU8 rgb) {
        this.renderer.setTextureImage(rgb);
    }

    public CameraPinhole getIntrinsicsCopy() {
        CameraPinhole camera = new CameraPinhole();
        PerspectiveOps.createIntrinsic((int)this.dimension.width, (int)this.dimension.height, (double)this.hfov, (double)-1.0, (CameraPinhole)camera);
        return camera;
    }

    @Generated
    public boolean isHelpButtonActive() {
        return this.helpButtonActive;
    }

    @Generated
    public void setHelpButtonActive(boolean helpButtonActive) {
        this.helpButtonActive = helpButtonActive;
    }

    @Generated
    public RenderMesh getRenderer() {
        return this.renderer;
    }

    @Generated
    public boolean isShowDepth() {
        return this.showDepth;
    }

    @Generated
    public void setShowDepth(boolean showDepth) {
        this.showDepth = showDepth;
    }

    @Generated
    public String getLastControlName() {
        return this.lastControlName;
    }

    @Generated
    public CustomPaint getCustomPaint() {
        return this.customPaint;
    }

    @Generated
    public void setCustomPaint(CustomPaint customPaint) {
        this.customPaint = customPaint;
    }

    @Generated
    public CameraChanged getCameraChanged() {
        return this.cameraChanged;
    }

    @Generated
    public void setCameraChanged(CameraChanged cameraChanged) {
        this.cameraChanged = cameraChanged;
    }

    public static interface CustomPaint {
        public void paint(Graphics2D var1);
    }

    public static interface CameraChanged {
        public void cameraChanged(CameraPinhole var1);
    }
}

