/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;

public class InterestPointDetectorOverride<T extends ImageSingleBand>
implements InterestPointDetector<T> {
    InterestPointDetector<T> detector;
    OrientationImage<T> orientation;

    public InterestPointDetectorOverride(InterestPointDetector<T> detector, OrientationImage<T> orientation) {
        this.detector = detector;
        this.orientation = orientation;
    }

    @Override
    public void detect(T input) {
        this.detector.detect(input);
        if (this.orientation != null) {
            this.orientation.setImage(input);
        }
    }

    @Override
    public int getNumberOfFeatures() {
        return this.detector.getNumberOfFeatures();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.detector.getLocation(featureIndex);
    }

    @Override
    public double getScale(int featureIndex) {
        return this.detector.getScale(featureIndex);
    }

    @Override
    public double getOrientation(int featureIndex) {
        if (this.orientation == null) {
            return this.detector.getOrientation(featureIndex);
        }
        Point2D_F64 p = this.detector.getLocation(featureIndex);
        this.orientation.setScale(this.getScale(featureIndex));
        return this.orientation.compute(p.x, p.y);
    }

    @Override
    public boolean hasScale() {
        return this.detector.hasScale();
    }

    @Override
    public boolean hasOrientation() {
        if (this.orientation == null) {
            return this.detector.hasOrientation();
        }
        return true;
    }
}

