/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_S8;
import boofcv.struct.feature.TupleDesc_U8;

public class DescriptorDistance {
    public static double euclidean(TupleDesc_F64 a, TupleDesc_F64 b) {
        int N = a.value.length;
        double total = 0.0;
        for (int i = 0; i < N; ++i) {
            double d = a.value[i] - b.value[i];
            total += d * d;
        }
        return Math.sqrt(total);
    }

    public static double euclideanSq(TupleDesc_F64 a, TupleDesc_F64 b) {
        int N = a.value.length;
        double total = 0.0;
        for (int i = 0; i < N; ++i) {
            double d = a.value[i] - b.value[i];
            total += d * d;
        }
        return total;
    }

    public static double euclideanSq(TupleDesc_F32 a, TupleDesc_F32 b) {
        int N = a.value.length;
        float total = 0.0f;
        for (int i = 0; i < N; ++i) {
            double d = a.value[i] - b.value[i];
            total = (float)((double)total + d * d);
        }
        return total;
    }

    public static double correlation(TupleDesc_F64 a, TupleDesc_F64 b) {
        int N = a.value.length;
        double total = 0.0;
        for (int i = 0; i < N; ++i) {
            total += a.value[i] * b.value[i];
        }
        return total;
    }

    public static double ncc(NccFeature a, NccFeature b) {
        double top = 0.0;
        int N = a.value.length;
        for (int i = 0; i < N; ++i) {
            top += a.value[i] * b.value[i];
        }
        return top / ((double)N * a.sigma * b.sigma);
    }

    public static int sad(TupleDesc_U8 a, TupleDesc_U8 b) {
        int total = 0;
        for (int i = 0; i < a.value.length; ++i) {
            total += Math.abs((a.value[i] & 0xFF) - (b.value[i] & 0xFF));
        }
        return total;
    }

    public static int sad(TupleDesc_S8 a, TupleDesc_S8 b) {
        int total = 0;
        for (int i = 0; i < a.value.length; ++i) {
            total += Math.abs(a.value[i] - b.value[i]);
        }
        return total;
    }

    public static float sad(TupleDesc_F32 a, TupleDesc_F32 b) {
        float total = 0.0f;
        for (int i = 0; i < a.value.length; ++i) {
            total += Math.abs(a.value[i] - b.value[i]);
        }
        return total;
    }

    public static double sad(TupleDesc_F64 a, TupleDesc_F64 b) {
        double total = 0.0;
        for (int i = 0; i < a.value.length; ++i) {
            total += Math.abs(a.value[i] - b.value[i]);
        }
        return total;
    }

    public static int hamming(TupleDesc_B a, TupleDesc_B b) {
        int score = 0;
        int N = a.data.length;
        for (int i = 0; i < N; ++i) {
            score += DescriptorDistance.hamming(a.data[i] ^ b.data[i]);
        }
        return score;
    }

    public static int hamming(int val) {
        int distance = 0;
        while (val != 0) {
            val &= val - 1;
            ++distance;
        }
        return distance;
    }
}

