/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.peak;

import boofcv.alg.feature.detect.peak.MeanShiftPeak;
import boofcv.struct.image.ImageSingleBand;

public class MeanShiftUniformPeak<T extends ImageSingleBand>
extends MeanShiftPeak<T> {
    public MeanShiftUniformPeak(int maxIterations, float convergenceTol, int radius, Class<T> imageType) {
        super(maxIterations, convergenceTol, radius, imageType);
    }

    @Override
    public void search(float cx, float cy) {
        this.peakX = cx;
        this.peakY = cy;
        this.setRegion(cx, cy);
        for (int i = 0; i < this.maxIterations; ++i) {
            float weight;
            int yy;
            float total = 0.0f;
            float sumX = 0.0f;
            float sumY = 0.0f;
            if (this.interpolate.isInFastBounds(this.x0, this.y0) && this.interpolate.isInFastBounds(this.x0 + (float)this.width - 1.0f, this.y0 + (float)this.width - 1.0f)) {
                for (yy = 0; yy < this.width; ++yy) {
                    for (int xx = 0; xx < this.width; ++xx) {
                        weight = this.interpolate.get_fast(this.x0 + (float)xx, this.y0 + (float)yy);
                        total += weight;
                        sumX += weight * ((float)xx + this.x0);
                        sumY += weight * ((float)yy + this.y0);
                    }
                }
            } else {
                for (yy = 0; yy < this.width; ++yy) {
                    for (int xx = 0; xx < this.width; ++xx) {
                        weight = this.interpolate.get(this.x0 + (float)xx, this.y0 + (float)yy);
                        total += weight;
                        sumX += weight * ((float)xx + this.x0);
                        sumY += weight * ((float)yy + this.y0);
                    }
                }
            }
            cx = sumX / total;
            cy = sumY / total;
            this.setRegion(cx, cy);
            float dx = cx - this.peakX;
            float dy = cy - this.peakY;
            this.peakX = cx;
            this.peakY = cy;
            if (Math.abs(dx) < this.convergenceTol && Math.abs(dy) < this.convergenceTol) break;
        }
    }
}

