/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.shapes;

import boofcv.alg.feature.shapes.SplitMergeLineFit;
import georegression.geometry.UtilPoint2D_I32;
import georegression.metric.Distance2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.GrowQueue_I32;

public class SplitMergeLineFitLoop
extends SplitMergeLineFit {
    protected int N;

    public SplitMergeLineFitLoop(double toleranceSplit, double toleranceMerge, int maxIterations) {
        super(toleranceSplit, toleranceMerge, maxIterations);
    }

    @Override
    public void process(List<Point2D_I32> contour) {
        this.contour = contour;
        this.N = contour.size();
        this.splits.reset();
        if (this.N <= 1) {
            return;
        }
        int startIndex = this.selectFarthest(contour);
        int middleIndex = (startIndex + this.N / 2) % this.N;
        this.splits.add(startIndex);
        this.splitPixels(startIndex, this.N / 2);
        this.splits.add(middleIndex);
        this.splitPixels(middleIndex, this.N - this.N / 2);
        if (this.splits.size <= 2) {
            return;
        }
        for (int i = 0; i < this.maxIterations && this.mergeSegments() && this.splitSegments(); ++i) {
        }
    }

    protected void splitPixels(int indexStart, int length) {
        if (length <= 1) {
            return;
        }
        int indexEnd = (indexStart + length) % this.N;
        Point2D_I32 a = (Point2D_I32)this.contour.get(indexStart);
        Point2D_I32 c = (Point2D_I32)this.contour.get(indexEnd);
        this.line.p.set((double)a.x, (double)a.y);
        this.line.slope.set((double)(c.x - a.x), (double)(c.y - a.y));
        int splitOffset = this.selectSplitOffset(indexStart, length);
        if (splitOffset >= 0) {
            this.splitPixels(indexStart, splitOffset);
            int indexSplit = (indexStart + splitOffset) % this.N;
            this.splits.add(indexSplit);
            this.splitPixels(indexSplit, this.circularDistance(indexSplit, indexEnd));
        }
    }

    protected int selectFarthest(List<Point2D_I32> contour) {
        int bestIndex = -1;
        int bestDistance = 0;
        int N = contour.size();
        int half = N / 2;
        for (int i = 0; i < half; ++i) {
            int end = (i + half) % N;
            Point2D_I32 a = contour.get(i);
            Point2D_I32 b = contour.get(end);
            int dist = UtilPoint2D_I32.distanceSq((int)a.x, (int)a.y, (int)b.x, (int)b.y);
            if (bestDistance >= dist) continue;
            bestIndex = i;
            bestDistance = dist;
        }
        if (bestIndex == -1) {
            System.out.println();
        }
        return bestIndex;
    }

    protected boolean mergeSegments() {
        boolean change = false;
        this.work.reset();
        Point2D_I32 a = (Point2D_I32)this.contour.get(this.splits.data[this.splits.size - 1]);
        Point2D_I32 b = (Point2D_I32)this.contour.get(this.splits.data[0]);
        Point2D_I32 c = (Point2D_I32)this.contour.get(this.splits.data[1]);
        double theta = this.computeAcute(a, b, c);
        if (theta > this.toleranceMerge) {
            this.work.add(this.splits.data[0]);
            a = b;
            b = c;
        } else {
            b = c;
            change = true;
        }
        for (int i = 0; i < this.splits.size - 2; ++i) {
            c = (Point2D_I32)this.contour.get(this.splits.data[i + 2]);
            theta = this.computeAcute(a, b, c);
            if (theta <= this.toleranceMerge) {
                change = true;
                b = c;
                continue;
            }
            this.work.add(this.splits.data[i + 1]);
            a = b;
            b = c;
        }
        c = (Point2D_I32)this.contour.get(this.work.data[0]);
        theta = this.computeAcute(a, b, c);
        if (theta > this.toleranceMerge) {
            this.work.add(this.splits.data[this.splits.size - 1]);
        } else {
            change = true;
        }
        GrowQueue_I32 tmp = this.work;
        this.work = this.splits;
        this.splits = tmp;
        return change;
    }

    protected boolean splitSegments() {
        boolean change = false;
        this.work.reset();
        for (int i = 0; i < this.splits.size - 1; ++i) {
            change = this.checkSplit(change, i, i + 1);
        }
        change = this.checkSplit(change, this.splits.size - 1, 0);
        GrowQueue_I32 tmp = this.work;
        this.work = this.splits;
        this.splits = tmp;
        return change;
    }

    private boolean checkSplit(boolean change, int i0, int i1) {
        int start = this.splits.data[i0];
        int end = this.splits.data[i1];
        int length = this.circularDistance(start, end);
        Point2D_I32 a = (Point2D_I32)this.contour.get(start);
        Point2D_I32 b = (Point2D_I32)this.contour.get(end);
        this.line.p.set((double)a.x, (double)a.y);
        this.line.slope.set((double)(b.x - a.x), (double)(b.y - a.y));
        int bestOffset = this.selectSplitOffset(start, length);
        if (bestOffset >= 0) {
            change = true;
            this.work.add(start);
            this.work.add((start + bestOffset) % this.N);
        } else {
            this.work.add(start);
        }
        return change;
    }

    protected int selectSplitOffset(int indexStart, int length) {
        int bestOffset = -1;
        double bestDistanceSq = 0.0;
        for (int i = 1; i < length; ++i) {
            Point2D_I32 b = (Point2D_I32)this.contour.get((indexStart + i) % this.N);
            this.point2D.set((double)b.x, (double)b.y);
            double dist = Distance2D_F64.distanceSq((LineParametric2D_F64)this.line, (Point2D_F64)this.point2D);
            if (!(dist > bestDistanceSq)) continue;
            bestDistanceSq = dist;
            bestOffset = i;
        }
        if (bestDistanceSq > this.toleranceSplitSq) {
            return bestOffset;
        }
        return -1;
    }

    protected int circularDistance(int start, int end) {
        if (end >= start) {
            return end - start;
        }
        return this.N - start + end;
    }
}

