/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.orientation;

import boofcv.abst.feature.orientation.OrientationGradient;
import boofcv.abst.feature.orientation.OrientationGradientToImage;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.abst.feature.orientation.OrientationIntegralToImage;
import boofcv.abst.feature.orientation.RegionOrientation;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.ImageSingleBand;

public class FactoryOrientation {
    public static <T extends ImageSingleBand> OrientationImage<T> convertImage(RegionOrientation algorithm, Class<T> imageType) {
        if (algorithm instanceof OrientationGradient) {
            Class derivType = ((OrientationGradient)algorithm).getImageType();
            ImageGradient gradient = FactoryDerivative.sobel(imageType, derivType);
            return new OrientationGradientToImage((OrientationGradient)algorithm, gradient, imageType, derivType);
        }
        if (algorithm instanceof OrientationIntegral) {
            Class integralType = GIntegralImageOps.getIntegralType(imageType);
            return new OrientationIntegralToImage((OrientationIntegral)algorithm, imageType, integralType);
        }
        throw new IllegalArgumentException("Unknown orientation algorithm type");
    }
}

