/*
 * Copyright (c) 2011-2014, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.alg.segmentation.fh04;

import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.FastQueue;

/**
 * Computes edge weights for {@link SegmentFelzenHutten04}.  An edge weight is measure of how different
 * two adjacent pixels are from each other.
 *
 * @author Peter Abeles
 */
public interface FhEdgeWeights<T extends ImageBase> {

	public void process( T input , FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges );

	public ImageType<T> getInputType();
}
