/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.edge.impl.ImplEdgeNonMaxSuppression;
import boofcv.alg.feature.detect.edge.impl.ImplEdgeNonMaxSuppressionCrude;
import boofcv.alg.feature.detect.edge.impl.ImplGradientToEdgeFeatures;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;

public class GradientToEdgeFeatures {
    public static void intensityE(ImageFloat32 derivX, ImageFloat32 derivY, ImageFloat32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityE(derivX, derivY, intensity);
    }

    public static void intensityAbs(ImageFloat32 derivX, ImageFloat32 derivY, ImageFloat32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityAbs(derivX, derivY, intensity);
    }

    public static void direction(ImageFloat32 derivX, ImageFloat32 derivY, ImageFloat32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction(derivX, derivY, angle);
    }

    public static void direction2(ImageFloat32 derivX, ImageFloat32 derivY, ImageFloat32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction2(derivX, derivY, angle);
    }

    public static void intensityE(ImageSInt16 derivX, ImageSInt16 derivY, ImageFloat32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityE(derivX, derivY, intensity);
    }

    public static void intensityAbs(ImageSInt16 derivX, ImageSInt16 derivY, ImageFloat32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityAbs(derivX, derivY, intensity);
    }

    public static void direction(ImageSInt16 derivX, ImageSInt16 derivY, ImageFloat32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction(derivX, derivY, angle);
    }

    public static void direction2(ImageSInt16 derivX, ImageSInt16 derivY, ImageFloat32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction2(derivX, derivY, angle);
    }

    public static void intensityE(ImageSInt32 derivX, ImageSInt32 derivY, ImageFloat32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityE(derivX, derivY, intensity);
    }

    public static void intensityAbs(ImageSInt32 derivX, ImageSInt32 derivY, ImageFloat32 intensity) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        ImplGradientToEdgeFeatures.intensityAbs(derivX, derivY, intensity);
    }

    public static void direction(ImageSInt32 derivX, ImageSInt32 derivY, ImageFloat32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction(derivX, derivY, angle);
    }

    public static void direction2(ImageSInt32 derivX, ImageSInt32 derivY, ImageFloat32 angle) {
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)angle);
        ImplGradientToEdgeFeatures.direction2(derivX, derivY, angle);
    }

    public static ImageSInt8 discretizeDirection4(ImageFloat32 angle, ImageSInt8 discrete) {
        discrete = (ImageSInt8)InputSanityCheck.checkDeclare((ImageSingleBand)angle, (ImageSingleBand)discrete, ImageSInt8.class);
        float A = 0.3926991f;
        float B = 0.7853982f;
        int w = angle.width;
        int h = angle.height;
        for (int y = 0; y < h; ++y) {
            int indexSrc = angle.startIndex + y * angle.stride;
            int indexDst = discrete.startIndex + y * discrete.stride;
            int end = indexSrc + w;
            while (indexSrc < end) {
                float a = angle.data[indexSrc];
                int val = a >= 0.0f ? (int)((a + 0.3926991f) / 0.7853982f) : (int)((a - 0.3926991f) / 0.7853982f);
                discrete.data[indexDst] = (byte)(val == -2 ? 2 : val);
                ++indexSrc;
                ++indexDst;
            }
        }
        return discrete;
    }

    public static ImageSInt8 discretizeDirection8(ImageFloat32 angle, ImageSInt8 discrete) {
        discrete = (ImageSInt8)InputSanityCheck.checkDeclare((ImageSingleBand)angle, (ImageSingleBand)discrete, ImageSInt8.class);
        float A = 0.3926991f;
        float B = 0.7853982f;
        int w = angle.width;
        int h = angle.height;
        for (int y = 0; y < h; ++y) {
            int indexSrc = angle.startIndex + y * angle.stride;
            int indexDst = discrete.startIndex + y * discrete.stride;
            int end = indexSrc + w;
            while (indexSrc < end) {
                float a = angle.data[indexSrc];
                int val = a >= 0.0f ? (int)((a + 0.3926991f) / 0.7853982f) : (int)((a - 0.3926991f) / 0.7853982f);
                discrete.data[indexDst] = (byte)(val == -4 ? 4 : val);
                ++indexSrc;
                ++indexDst;
            }
        }
        return discrete;
    }

    public static ImageFloat32 nonMaxSuppression4(ImageFloat32 intensity, ImageSInt8 direction, ImageFloat32 output) {
        InputSanityCheck.checkSameShape((ImageBase)intensity, (ImageBase)direction);
        output = (ImageFloat32)InputSanityCheck.checkDeclare((ImageSingleBand)intensity, (ImageSingleBand)output);
        ImplEdgeNonMaxSuppression.inner4(intensity, direction, output);
        ImplEdgeNonMaxSuppression.border4(intensity, direction, output);
        return output;
    }

    public static ImageFloat32 nonMaxSuppression8(ImageFloat32 intensity, ImageSInt8 direction, ImageFloat32 output) {
        InputSanityCheck.checkSameShape((ImageBase)intensity, (ImageBase)direction);
        output = (ImageFloat32)InputSanityCheck.checkDeclare((ImageSingleBand)intensity, (ImageSingleBand)output);
        ImplEdgeNonMaxSuppression.inner8(intensity, direction, output);
        ImplEdgeNonMaxSuppression.border8(intensity, direction, output);
        return output;
    }

    public static ImageFloat32 nonMaxSuppressionCrude4(ImageFloat32 intensity, ImageFloat32 derivX, ImageFloat32 derivY, ImageFloat32 output) {
        InputSanityCheck.checkSameShape((ImageBase)intensity, (ImageBase)derivX, (ImageBase)derivY);
        output = (ImageFloat32)InputSanityCheck.checkDeclare((ImageSingleBand)intensity, (ImageSingleBand)output);
        ImplEdgeNonMaxSuppressionCrude.inner4(intensity, derivX, derivY, output);
        ImplEdgeNonMaxSuppressionCrude.border4(intensity, derivX, derivY, output);
        return output;
    }

    public static ImageFloat32 nonMaxSuppressionCrude4(ImageFloat32 intensity, ImageSInt16 derivX, ImageSInt16 derivY, ImageFloat32 output) {
        InputSanityCheck.checkSameShape((ImageBase)intensity, (ImageBase)derivX, (ImageBase)derivY);
        output = (ImageFloat32)InputSanityCheck.checkDeclare((ImageSingleBand)intensity, (ImageSingleBand)output);
        ImplEdgeNonMaxSuppressionCrude.inner4(intensity, derivX, derivY, output);
        ImplEdgeNonMaxSuppressionCrude.border4(intensity, (ImageInteger)derivX, (ImageInteger)derivY, output);
        return output;
    }

    public static ImageFloat32 nonMaxSuppressionCrude4(ImageFloat32 intensity, ImageSInt32 derivX, ImageSInt32 derivY, ImageFloat32 output) {
        InputSanityCheck.checkSameShape((ImageBase)intensity, (ImageBase)derivX, (ImageBase)derivY);
        output = (ImageFloat32)InputSanityCheck.checkDeclare((ImageSingleBand)intensity, (ImageSingleBand)output);
        ImplEdgeNonMaxSuppressionCrude.inner4(intensity, derivX, derivY, output);
        ImplEdgeNonMaxSuppressionCrude.border4(intensity, (ImageInteger)derivX, (ImageInteger)derivY, output);
        return output;
    }
}

