/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GImageMultiBand;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class BackgroundStationaryGaussian_MS<T extends ImageSingleBand>
extends BackgroundStationaryGaussian<MultiSpectral<T>> {
    protected GImageMultiBand inputWrapper;
    protected GImageMultiBand bgWrapper;
    protected float[] inputPixel;
    MultiSpectral<ImageFloat32> background;

    public BackgroundStationaryGaussian_MS(float learnRate, float threshold, ImageType<MultiSpectral<T>> imageType) {
        super(learnRate, threshold, imageType);
        int numBands = imageType.getNumBands();
        this.background = new MultiSpectral(ImageFloat32.class, 1, 1, 2 * numBands);
        this.bgWrapper = FactoryGImageMultiBand.create((ImageType)this.background.getImageType());
        this.bgWrapper.wrap(this.background);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
        this.inputPixel = new float[numBands];
    }

    @Override
    public void reset() {
        this.background.reshape(1, 1);
    }

    @Override
    public void updateBackground(MultiSpectral<T> frame) {
        if (this.background.width == 1) {
            this.background.reshape(frame.width, frame.height);
            for (int band = 0; band < this.background.getNumBands(); band += 2) {
                GConvertImage.convert((ImageBase)frame.getBand(band / 2), (ImageBase)this.background.getBand(band));
                GImageMiscOps.fill((ImageBase)this.background.getBand(band + 1), (double)this.initialVariance);
            }
            return;
        }
        InputSanityCheck.checkSameShape(this.background, frame);
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands() / 2;
        float minusLearn = 1.0f - this.learnRate;
        int indexBG = 0;
        for (int y = 0; y < this.background.height; ++y) {
            int indexInput = frame.startIndex + y * frame.stride;
            int end = indexInput + frame.width;
            while (indexInput < end) {
                this.inputWrapper.getF(indexInput, this.inputPixel);
                for (int band = 0; band < numBands; ++band) {
                    ImageFloat32 backgroundMean = (ImageFloat32)this.background.getBand(band * 2);
                    ImageFloat32 backgroundVar = (ImageFloat32)this.background.getBand(band * 2 + 1);
                    float inputValue = this.inputPixel[band];
                    float meanBG = backgroundMean.data[indexBG];
                    float varianceBG = backgroundVar.data[indexBG];
                    float diff = meanBG - inputValue;
                    backgroundMean.data[indexBG] = minusLearn * meanBG + this.learnRate * inputValue;
                    backgroundVar.data[indexBG] = minusLearn * varianceBG + this.learnRate * diff * diff;
                }
                ++indexInput;
                ++indexBG;
            }
        }
    }

    @Override
    public void segment(MultiSpectral<T> frame, ImageUInt8 segmented) {
        if (this.background.width == 1) {
            ImageMiscOps.fill((ImageInt8)segmented, (int)this.unknownValue);
            return;
        }
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands() / 2;
        float adjustedMinimumDifference = this.minimumDifference * (float)numBands;
        int indexBG = 0;
        for (int y = 0; y < frame.height; ++y) {
            int indexInput = frame.startIndex + y * frame.stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int end = indexInput + frame.width;
            while (indexInput < end) {
                this.inputWrapper.getF(indexInput, this.inputPixel);
                float mahalanobis = 0.0f;
                for (int band = 0; band < numBands; ++band) {
                    ImageFloat32 backgroundMean = (ImageFloat32)this.background.getBand(band * 2);
                    ImageFloat32 backgroundVar = (ImageFloat32)this.background.getBand(band * 2 + 1);
                    float meanBG = backgroundMean.data[indexBG];
                    float varBG = backgroundVar.data[indexBG];
                    float diff = meanBG - this.inputPixel[band];
                    mahalanobis += diff * diff / varBG;
                }
                if (mahalanobis <= this.threshold) {
                    segmented.data[indexSegmented] = 0;
                } else if (this.minimumDifference == 0.0f) {
                    segmented.data[indexSegmented] = 1;
                } else {
                    float sumAbsDiff = 0.0f;
                    for (int band = 0; band < numBands; ++band) {
                        ImageFloat32 backgroundMean = (ImageFloat32)this.background.getBand(band * 2);
                        sumAbsDiff += Math.abs(backgroundMean.data[indexBG] - this.inputPixel[band]);
                    }
                    segmented.data[indexSegmented] = sumAbsDiff >= adjustedMinimumDifference ? (byte)1 : 0;
                }
                ++indexInput;
                ++indexSegmented;
                ++indexBG;
            }
        }
    }
}

