/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.sparse.GradientValue;
import boofcv.struct.sparse.SparseImageGradient;

public class DescribePointSurfMod<II extends ImageSingleBand>
extends DescribePointSurf<II> {
    private int overLap;
    private Kernel2D_F64 weightGrid;
    private Kernel2D_F64 weightSub;
    private double[] samplesX;
    private double[] samplesY;

    public DescribePointSurfMod(int widthLargeGrid, int widthSubRegion, int widthSample, int overLap, double sigmaLargeGrid, double sigmaSubRegion, boolean useHaar, Class<II> imageType) {
        super(widthLargeGrid, widthSubRegion, widthSample, 1.0, useHaar, imageType);
        this.overLap = overLap;
        this.weightGrid = FactoryKernelGaussian.gaussianWidth((double)sigmaLargeGrid, (int)widthLargeGrid);
        this.weightSub = FactoryKernelGaussian.gaussianWidth((double)sigmaSubRegion, (int)(widthSubRegion + 2 * overLap));
        double div = this.weightGrid.get(this.weightGrid.getRadius(), this.weightGrid.getRadius());
        int i = 0;
        while (i < this.weightGrid.data.length) {
            int n = i++;
            this.weightGrid.data[n] = this.weightGrid.data[n] / div;
        }
        div = this.weightSub.get(this.weightSub.getRadius(), this.weightSub.getRadius());
        i = 0;
        while (i < this.weightSub.data.length) {
            int n = i++;
            this.weightSub.data[n] = this.weightSub.data[n] / div;
        }
        int sampleWidth = widthLargeGrid * widthSubRegion + overLap * 2;
        this.samplesX = new double[sampleWidth * sampleWidth];
        this.samplesY = new double[sampleWidth * sampleWidth];
        this.radiusDescriptor = widthLargeGrid * widthSubRegion / 2 + overLap;
    }

    public DescribePointSurfMod(Class<II> imageType) {
        this(4, 5, 3, 2, 2.5, 2.5, false, imageType);
    }

    @Override
    public void features(double c_x, double c_y, double c, double s, double scale, SparseImageGradient gradient, double[] features) {
        int regionSize = this.widthLargeGrid * this.widthSubRegion;
        int totalSampleWidth = this.widthSubRegion + this.overLap * 2;
        int regionR = regionSize / 2;
        int regionEnd = regionSize - regionR;
        int sampleGridWidth = regionSize + 2 * this.overLap;
        int regionIndex = 0;
        c_x += 0.5;
        c_y += 0.5;
        int index = 0;
        for (int rY = -regionR - this.overLap; rY < regionEnd + this.overLap; ++rY) {
            double regionY = (double)rY * scale;
            int rX = -regionR - this.overLap;
            while (rX < regionEnd + this.overLap) {
                double regionX = (double)rX * scale;
                int pixelX = (int)(c_x + c * regionX - s * regionY);
                int pixelY = (int)(c_y + s * regionX + c * regionY);
                GradientValue g = gradient.compute(pixelX, pixelY);
                this.samplesX[index] = g.getX();
                this.samplesY[index] = g.getY();
                ++rX;
                ++index;
            }
        }
        int indexGridWeight = 0;
        for (int rY = -regionR; rY < regionEnd; rY += this.widthSubRegion) {
            for (int rX = -regionR; rX < regionEnd; rX += this.widthSubRegion) {
                double sum_dx = 0.0;
                double sum_dy = 0.0;
                double sum_adx = 0.0;
                double sum_ady = 0.0;
                for (int i = 0; i < totalSampleWidth; ++i) {
                    index = (rY + regionR + i) * sampleGridWidth + rX + regionR;
                    int j = 0;
                    while (j < totalSampleWidth) {
                        double w = this.weightSub.get(j, i);
                        double dx = w * this.samplesX[index];
                        double dy = w * this.samplesY[index];
                        double pdx = c * dx + s * dy;
                        double pdy = -s * dx + c * dy;
                        sum_dx += pdx;
                        sum_adx += Math.abs(pdx);
                        sum_dy += pdy;
                        sum_ady += Math.abs(pdy);
                        ++j;
                        ++index;
                    }
                }
                double w = this.weightGrid.data[indexGridWeight++];
                features[regionIndex++] = w * sum_dx;
                features[regionIndex++] = w * sum_adx;
                features[regionIndex++] = w * sum_dy;
                features[regionIndex++] = w * sum_ady;
            }
        }
    }

    @Override
    public int getCanonicalWidth() {
        return super.getCanonicalWidth() + 2 * this.overLap;
    }
}

