/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.alg.feature.describe.impl.ImplSurfDescribeOps;
import boofcv.factory.transform.ii.FactorySparseIntegralFilters;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.sparse.SparseScaleGradient;

public class SurfDescribeOps {
    public static <T extends ImageSingleBand> void gradient(T ii, double tl_x, double tl_y, double samplePeriod, int regionSize, double kernelWidth, boolean useHaar, double[] derivX, double[] derivY) {
        ImplSurfDescribeOps.naiveGradient(ii, tl_x, tl_y, samplePeriod, regionSize, kernelWidth, useHaar, derivX, derivY);
    }

    public static void gradient_noborder(ImageFloat32 ii, double tl_x, double tl_y, double samplePeriod, int regionSize, double kernelWidth, float[] derivX, float[] derivY) {
        ImplSurfDescribeOps.gradientInner(ii, tl_x, tl_y, samplePeriod, regionSize, kernelWidth, derivX, derivY);
    }

    public static void gradient_noborder(ImageSInt32 ii, double tl_x, double tl_y, double samplePeriod, int regionSize, double kernelWidth, int[] derivX, int[] derivY) {
        ImplSurfDescribeOps.gradientInner(ii, tl_x, tl_y, samplePeriod, regionSize, kernelWidth, derivX, derivY);
    }

    public static <T extends ImageSingleBand> SparseScaleGradient<T, ?> createGradient(boolean useHaar, int kernelWidth, Class<T> imageType) {
        int regionRadius = kernelWidth / 2;
        if (regionRadius <= 0) {
            regionRadius = 1;
        }
        if (useHaar) {
            return FactorySparseIntegralFilters.haar((int)regionRadius, imageType);
        }
        return FactorySparseIntegralFilters.gradient((int)regionRadius, imageType);
    }

    public static <T extends ImageSingleBand> boolean isInside(T ii, double X, double Y, int radiusRegions, int kernelSize, double scale, double c, double s) {
        int x0;
        int c_x = (int)Math.round(X);
        int c_y = (int)Math.round(Y);
        kernelSize = (int)Math.ceil((double)kernelSize * scale);
        int kernelRadius = kernelSize / 2 + kernelSize % 2;
        int radius = (int)Math.ceil((double)radiusRegions * scale);
        int kernelPaddingMinus = radius + kernelRadius + 1;
        int kernelPaddingPlus = radius + kernelRadius;
        if (c != 0.0 || s != 0.0) {
            double yy;
            double xx = Math.abs(c * (double)kernelPaddingMinus - s * (double)kernelPaddingMinus);
            double delta = xx > (yy = Math.abs(s * (double)kernelPaddingMinus + c * (double)kernelPaddingMinus)) ? xx - (double)kernelPaddingMinus : yy - (double)kernelPaddingMinus;
            kernelPaddingMinus += (int)Math.ceil(delta);
            kernelPaddingPlus += (int)Math.ceil(delta);
        }
        if ((x0 = c_x - kernelPaddingMinus) < 0) {
            return false;
        }
        int x1 = c_x + kernelPaddingPlus;
        if (x1 >= ii.width) {
            return false;
        }
        int y0 = c_y - kernelPaddingMinus;
        if (y0 < 0) {
            return false;
        }
        int y1 = c_y + kernelPaddingPlus;
        return y1 < ii.height;
    }

    public static boolean isInside(int width, int height, double tl_x, double tl_y, double regionSize, double sampleSize) {
        int w = (int)(sampleSize + 0.5);
        int r = w / 2 + w % 2;
        int x0 = (int)(tl_x + 0.5) - r - 1;
        int y0 = (int)(tl_y + 0.5) - r - 1;
        if (x0 < 0 || y0 < 0) {
            return false;
        }
        int x1 = (int)(tl_x + regionSize + 0.5) + r;
        int y1 = (int)(tl_y + regionSize + 0.5) + r;
        return x1 < width && y1 < height;
    }

    public static double rotatedWidth(double width, double c, double s) {
        return Math.abs(c) * width + Math.abs(s) * width;
    }
}

