/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageFloat32;

public class NonMaxExtractorNaive {
    protected int radius;
    protected float thresh;
    protected int border;
    protected boolean useStrictRule;

    public NonMaxExtractorNaive(boolean useStrictRule) {
        this.useStrictRule = useStrictRule;
    }

    public void setSearchRadius(int radius) {
        this.radius = radius;
    }

    public float getThreshold() {
        return this.thresh;
    }

    public void setThreshold(float thresh) {
        this.thresh = thresh;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public int getBorder() {
        return this.border;
    }

    public boolean isStrict() {
        return this.useStrictRule;
    }

    public void process(ImageFloat32 intensityImage, QueueCorner peaks) {
        if (this.useStrictRule) {
            this.strictRule(intensityImage, peaks);
        } else {
            this.notStrictRule(intensityImage, peaks);
        }
    }

    private void strictRule(ImageFloat32 intensityImage, QueueCorner corners) {
        int imgWidth = intensityImage.getWidth();
        int imgHeight = intensityImage.getHeight();
        float[] inten = intensityImage.data;
        for (int y = this.border; y < imgHeight - this.border; ++y) {
            int center = intensityImage.startIndex + y * intensityImage.stride + this.border;
            for (int x = this.border; x < imgWidth - this.border; ++x) {
                float val;
                if ((val = inten[center++]) < this.thresh) continue;
                boolean max = true;
                int x0 = x - this.radius;
                int x1 = x + this.radius;
                int y0 = y - this.radius;
                int y1 = y + this.radius;
                if (x0 < this.border) {
                    x0 = this.border;
                }
                if (y0 < this.border) {
                    y0 = this.border;
                }
                if (x1 >= imgWidth - this.border) {
                    x1 = imgWidth - this.border - 1;
                }
                if (y1 >= imgHeight - this.border) {
                    y1 = imgHeight - this.border - 1;
                }
                block2: for (int i = y0; i <= y1; ++i) {
                    int index = intensityImage.startIndex + i * intensityImage.stride + x0;
                    int j = x0;
                    while (j <= x1) {
                        if ((i != y || j != x) && val <= inten[index]) {
                            max = false;
                            break block2;
                        }
                        ++j;
                        ++index;
                    }
                }
                if (!max || val == Float.MAX_VALUE) continue;
                corners.add(x, y);
            }
        }
    }

    private void notStrictRule(ImageFloat32 intensityImage, QueueCorner corners) {
        int imgWidth = intensityImage.getWidth();
        int imgHeight = intensityImage.getHeight();
        float[] inten = intensityImage.data;
        for (int y = this.border; y < imgHeight - this.border; ++y) {
            int center = intensityImage.startIndex + y * intensityImage.stride + this.border;
            for (int x = this.border; x < imgWidth - this.border; ++x) {
                float val;
                if ((val = inten[center++]) < this.thresh) continue;
                boolean max = true;
                int x0 = x - this.radius;
                int x1 = x + this.radius;
                int y0 = y - this.radius;
                int y1 = y + this.radius;
                if (x0 < this.border) {
                    x0 = this.border;
                }
                if (y0 < this.border) {
                    y0 = this.border;
                }
                if (x1 >= imgWidth - this.border) {
                    x1 = imgWidth - this.border - 1;
                }
                if (y1 >= imgHeight - this.border) {
                    y1 = imgHeight - this.border - 1;
                }
                block2: for (int i = y0; i <= y1; ++i) {
                    int index = intensityImage.startIndex + i * intensityImage.stride + x0;
                    int j = x0;
                    while (j <= x1) {
                        if (val < inten[index]) {
                            max = false;
                            break block2;
                        }
                        ++j;
                        ++index;
                    }
                }
                if (!max || val == Float.MAX_VALUE) continue;
                corners.add(x, y);
            }
        }
    }

    public int getSearchRadius() {
        return this.radius;
    }
}

