/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.template;

import boofcv.alg.feature.detect.template.BaseTemplateIntensity;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;

public abstract class TemplateDiffSquared<T extends ImageBase>
extends BaseTemplateIntensity<T> {
    @Override
    public boolean isBorderProcessed() {
        return false;
    }

    public static class U8
    extends TemplateDiffSquared<ImageUInt8> {
        @Override
        protected float evaluate(int tl_x, int tl_y) {
            float total = 0.0f;
            float div = 65025.0f;
            for (int y = 0; y < ((ImageUInt8)this.template).height; ++y) {
                int imageIndex = ((ImageUInt8)this.image).startIndex + (tl_y + y) * ((ImageUInt8)this.image).stride + tl_x;
                int templateIndex = ((ImageUInt8)this.template).startIndex + y * ((ImageUInt8)this.template).stride;
                int rowTotal = 0;
                for (int x = 0; x < ((ImageUInt8)this.template).width; ++x) {
                    int error = (((ImageUInt8)this.image).data[imageIndex++] & 0xFF) - (((ImageUInt8)this.template).data[templateIndex++] & 0xFF);
                    rowTotal += error * error;
                }
                total += (float)rowTotal / div;
            }
            return -total;
        }

        @Override
        protected float evaluateMask(int tl_x, int tl_y) {
            float total = 0.0f;
            float div = 1.6581375E7f;
            for (int y = 0; y < ((ImageUInt8)this.template).height; ++y) {
                int imageIndex = ((ImageUInt8)this.image).startIndex + (tl_y + y) * ((ImageUInt8)this.image).stride + tl_x;
                int templateIndex = ((ImageUInt8)this.template).startIndex + y * ((ImageUInt8)this.template).stride;
                int maskIndex = ((ImageUInt8)this.mask).startIndex + y * ((ImageUInt8)this.mask).stride;
                int rowTotal = 0;
                for (int x = 0; x < ((ImageUInt8)this.template).width; ++x) {
                    int m = ((ImageUInt8)this.mask).data[maskIndex++] & 0xFF;
                    int error = (((ImageUInt8)this.image).data[imageIndex++] & 0xFF) - (((ImageUInt8)this.template).data[templateIndex++] & 0xFF);
                    rowTotal += m * error * error;
                }
                total += (float)rowTotal / div;
            }
            return -total;
        }
    }

    public static class F32
    extends TemplateDiffSquared<ImageFloat32> {
        @Override
        protected float evaluate(int tl_x, int tl_y) {
            float total = 0.0f;
            for (int y = 0; y < ((ImageFloat32)this.template).height; ++y) {
                int imageIndex = ((ImageFloat32)this.image).startIndex + (tl_y + y) * ((ImageFloat32)this.image).stride + tl_x;
                int templateIndex = ((ImageFloat32)this.template).startIndex + y * ((ImageFloat32)this.template).stride;
                for (int x = 0; x < ((ImageFloat32)this.template).width; ++x) {
                    float error = ((ImageFloat32)this.image).data[imageIndex++] - ((ImageFloat32)this.template).data[templateIndex++];
                    total += error * error;
                }
            }
            return -total;
        }

        @Override
        protected float evaluateMask(int tl_x, int tl_y) {
            float total = 0.0f;
            for (int y = 0; y < ((ImageFloat32)this.template).height; ++y) {
                int imageIndex = ((ImageFloat32)this.image).startIndex + (tl_y + y) * ((ImageFloat32)this.image).stride + tl_x;
                int templateIndex = ((ImageFloat32)this.template).startIndex + y * ((ImageFloat32)this.template).stride;
                int maskIndex = ((ImageFloat32)this.mask).startIndex + y * ((ImageFloat32)this.mask).stride;
                for (int x = 0; x < ((ImageFloat32)this.template).width; ++x) {
                    float error = ((ImageFloat32)this.image).data[imageIndex++] - ((ImageFloat32)this.template).data[templateIndex++];
                    total += ((ImageFloat32)this.mask).data[maskIndex++] * error * error;
                }
            }
            return -total;
        }
    }
}

