/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.edge;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.shapes.edge.BaseIntegralEdge;
import boofcv.core.image.GImageSingleBandDistorted;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;

public class PolygonEdgeScore<T extends ImageSingleBand>
extends BaseIntegralEdge<T> {
    double cornerOffset;
    double tangentDistance;
    int numSamples;
    double thresholdScore;
    Point2D_F64 offsetA = new Point2D_F64();
    Point2D_F64 offsetB = new Point2D_F64();
    double averageEdgeIntensity;

    public PolygonEdgeScore(double cornerOffset, double tangentDistance, int numSamples, double thresholdScore, Class<T> imageType) {
        super(imageType);
        this.cornerOffset = cornerOffset;
        this.tangentDistance = tangentDistance;
        this.numSamples = numSamples;
        this.thresholdScore = thresholdScore;
    }

    @Override
    public void setTransform(PixelTransform_F32 undistToDist) {
        InterpolatePixelS interpolate = FactoryInterpolation.bilinearPixelS((Class)this.imageType, (BorderType)BorderType.EXTENDED);
        this.integralImage = new GImageSingleBandDistorted(undistToDist, interpolate);
    }

    @Override
    public void setImage(T image) {
        this.integralImage.wrap(image);
        this.integral.setImage(this.integralImage);
    }

    public boolean validate(Polygon2D_F64 polygon) {
        double total = 0.0;
        for (int i = 0; i < polygon.size(); ++i) {
            int j = i + 1;
            if (j == polygon.size()) {
                j = 0;
            }
            Point2D_F64 a = polygon.get(i);
            Point2D_F64 b = polygon.get(j);
            double dx = b.x - a.x;
            double dy = b.y - a.y;
            double t = Math.sqrt(dx * dx + dy * dy);
            dx /= t;
            dy /= t;
            if (t <= 3.0 * this.cornerOffset) {
                return false;
            }
            this.offsetA.x = a.x + this.cornerOffset * dx;
            this.offsetA.y = a.y + this.cornerOffset * dy;
            this.offsetB.x = b.x - this.cornerOffset * dx;
            this.offsetB.y = b.y - this.cornerOffset * dy;
            total += this.scoreLine(this.offsetA, this.offsetB, -dy, dx);
        }
        this.averageEdgeIntensity = Math.abs(total) / ((double)(polygon.size() * this.numSamples * 2) * this.tangentDistance);
        return this.averageEdgeIntensity >= this.thresholdScore;
    }

    protected double scoreLine(Point2D_F64 a, Point2D_F64 b, double tanX, double tanY) {
        double total = 0.0;
        for (int i = 0; i < this.numSamples; ++i) {
            double x = (b.x - a.x) * (double)i / (double)(this.numSamples - 1) + a.x;
            double y = (b.y - a.y) * (double)i / (double)(this.numSamples - 1) + a.y;
            double x0 = x + tanX;
            double y0 = y + tanY;
            if (!BoofMiscOps.checkInside((int)this.integralImage.getWidth(), (int)this.integralImage.getHeight(), (double)x0, (double)y0)) continue;
            double x1 = x - tanX;
            double y1 = y - tanY;
            if (!BoofMiscOps.checkInside((int)this.integralImage.getWidth(), (int)this.integralImage.getHeight(), (double)x1, (double)y1)) continue;
            double up = this.integral.compute(x, y, x0, y0);
            double down = this.integral.compute(x, y, x1, y1);
            total += up - down;
        }
        return total;
    }

    public double getCornerOffset() {
        return this.cornerOffset;
    }

    public void setCornerOffset(double cornerOffset) {
        this.cornerOffset = cornerOffset;
    }

    public double getTangentDistance() {
        return this.tangentDistance;
    }

    public void setTangentDistance(double tangentDistance) {
        this.tangentDistance = tangentDistance;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public double getThresholdScore() {
        return this.thresholdScore;
    }

    public void setThresholdScore(double thresholdScore) {
        this.thresholdScore = thresholdScore;
    }

    public double getAverageEdgeIntensity() {
        return this.averageEdgeIntensity;
    }
}

