/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.LinearContourLabelChang2004;
import boofcv.alg.shapes.edge.PolygonEdgeScore;
import boofcv.alg.shapes.polygon.RefinePolygonCornersToImage;
import boofcv.alg.shapes.polygon.RefinePolygonLineToImage;
import boofcv.alg.shapes.polyline.RefinePolyLine;
import boofcv.alg.shapes.polyline.SplitMergeLineFitLoop;
import boofcv.struct.ConnectRule;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.metric.Area2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.RectangleLength2D_F32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class BinaryPolygonConvexDetector<T extends ImageSingleBand> {
    private double splitDistanceFraction;
    private double minContourFraction;
    private int minimumContour;
    private double minimumArea;
    private LinearContourLabelChang2004 contourFinder = new LinearContourLabelChang2004(ConnectRule.FOUR);
    private ImageSInt32 labeled = new ImageSInt32(1, 1);
    private SplitMergeLineFitLoop fitPolygon;
    private RefinePolyLine improveContour = new RefinePolyLine(true, 20);
    private RefinePolygonLineToImage<T> refineLine;
    private RefinePolygonCornersToImage<T> refineCorner;
    private FastQueue<Polygon2D_F64> found;
    private Class<T> inputType;
    private int[] numberOfSides;
    private Polygon2D_F64 workPoly = new Polygon2D_F64();
    private boolean outputClockwise;
    private List<Contour> foundContours = new ArrayList<Contour>();
    protected PixelTransform_F32 toUndistorted;
    protected PixelTransform_F32 toDistorted;
    boolean verbose = false;
    PolygonEdgeScore differenceScore;
    boolean checkEdgeBefore = true;

    public BinaryPolygonConvexDetector(int[] polygonSides, SplitMergeLineFitLoop contourToPolygon, PolygonEdgeScore differenceScore, RefinePolygonLineToImage<T> refineLine, RefinePolygonCornersToImage<T> refineCorner, double minContourFraction, double splitDistanceFraction, boolean outputClockwise, Class<T> inputType) {
        this.refineLine = refineLine;
        this.refineCorner = refineCorner;
        this.differenceScore = differenceScore;
        this.numberOfSides = polygonSides;
        this.inputType = inputType;
        this.minContourFraction = minContourFraction;
        this.fitPolygon = contourToPolygon;
        this.splitDistanceFraction = splitDistanceFraction;
        this.outputClockwise = outputClockwise;
        this.workPoly = new Polygon2D_F64(1);
        this.found = new FastQueue(Polygon2D_F64.class, true);
    }

    public void setLensDistortion(int width, int height, PixelTransform_F32 toUndistorted, PixelTransform_F32 toDistorted) {
        this.toUndistorted = toUndistorted;
        this.toDistorted = toDistorted;
        RectangleLength2D_F32 rect = DistortImageOps.boundBox_F32((int)width, (int)height, (PixelTransform_F32)toUndistorted);
        float x1 = rect.x0 + rect.width;
        float y1 = rect.y0 + rect.height;
        float tol = 1.0E-4f;
        if (rect.getX() < -tol || rect.getY() < -tol || x1 > (float)width + tol || y1 > (float)height + tol) {
            throw new IllegalArgumentException("You failed the idiot test! RTFM! The undistorted image must be contained by the same bounds as the input distorted image");
        }
        if (this.refineLine != null) {
            this.refineLine.getSnapToEdge().setTransform(toDistorted);
        }
        if (this.refineCorner != null) {
            this.refineCorner.getSnapToEdge().setTransform(toDistorted);
        }
        if (this.differenceScore != null) {
            this.differenceScore.setTransform(toDistorted);
        }
    }

    public void process(T gray, ImageUInt8 binary) {
        InputSanityCheck.checkSameShape((ImageBase)binary, gray);
        if (this.labeled.width != ((ImageSingleBand)gray).width || this.labeled.height == ((ImageSingleBand)gray).width) {
            this.configure(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
        }
        this.found.reset();
        this.foundContours.clear();
        if (this.differenceScore != null) {
            this.differenceScore.setImage(gray);
        }
        this.findCandidateShapes(gray, binary);
    }

    private void configure(int width, int height) {
        this.labeled.reshape(width, height);
        this.minimumContour = (int)((double)width * this.minContourFraction);
        this.minimumArea = Math.pow((double)this.minimumContour / 4.0, 2.0);
    }

    private void findCandidateShapes(T gray, ImageUInt8 binary) {
        this.contourFinder.process(binary, this.labeled);
        FastQueue blobs = this.contourFinder.getContours();
        for (int i = 0; i < blobs.size; ++i) {
            boolean success;
            Contour c = (Contour)blobs.get(i);
            if (c.external.size() < this.minimumContour || this.touchesBorder(c.external)) continue;
            if (this.toUndistorted != null) {
                this.removeDistortionFromContour(c.external);
            }
            double splitTolerance = this.splitDistanceFraction * (double)c.external.size();
            this.fitPolygon.setToleranceSplit(splitTolerance);
            this.fitPolygon.process(c.external);
            GrowQueue_I32 splits = this.fitPolygon.getSplits();
            if (!this.expectedNumberOfSides(splits)) {
                if (!this.verbose) continue;
                System.out.println("rejected number of sides. " + splits.size());
                continue;
            }
            if (!this.improveContour.fit(c.external, splits)) {
                if (!this.verbose) continue;
                System.out.println("rejected improve contour");
                continue;
            }
            this.workPoly.vertexes.resize(splits.size());
            for (int j = 0; j < splits.size(); ++j) {
                Point2D_I32 p = (Point2D_I32)c.external.get(splits.get(j));
                this.workPoly.get(j).set((double)p.x, (double)p.y);
            }
            if (!UtilPolygons2D_F64.isConvex((Polygon2D_F64)this.workPoly)) {
                if (!this.verbose) continue;
                System.out.println("Rejected not convex");
                continue;
            }
            double area = Area2D_F64.polygonConvex((Polygon2D_F64)this.workPoly);
            if (area < this.minimumArea) {
                if (!this.verbose) continue;
                System.out.println("Rejected area");
                continue;
            }
            boolean workOrigCCW = this.workPoly.isCCW();
            if (workOrigCCW) {
                this.workPoly.flip();
                if (this.workPoly.isCCW()) {
                    throw new RuntimeException("BUG!!!!");
                }
            }
            if (this.checkEdgeBefore && this.differenceScore != null && !this.differenceScore.validate(this.workPoly)) {
                if (!this.verbose) continue;
                System.out.println("Rejected edge score, after: " + this.differenceScore.getAverageEdgeIntensity());
                continue;
            }
            Polygon2D_F64 refined = (Polygon2D_F64)this.found.grow();
            refined.vertexes.resize(splits.size);
            if (this.refineCorner != null) {
                this.refineCorner.setImage(gray);
                boolean bl = success = this.refineCorner.refine(c.external, splits, refined) >= 3;
                if (workOrigCCW) {
                    refined.flip();
                }
            } else if (this.refineLine != null) {
                this.refineLine.setImage(gray);
                success = this.refineLine.refine(this.workPoly, refined);
            } else {
                refined.set(this.workPoly);
                success = true;
            }
            if (!this.checkEdgeBefore && this.differenceScore != null && !this.differenceScore.validate(refined)) {
                if (!this.verbose) continue;
                System.out.println("Rejected edge score, after: " + this.differenceScore.getAverageEdgeIntensity());
                continue;
            }
            if (!this.outputClockwise) {
                refined.flip();
            }
            if (success) {
                c.id = this.found.size();
                this.foundContours.add(c);
                continue;
            }
            this.found.removeTail();
            if (!this.verbose) continue;
            System.out.println("Rejected after refine");
        }
    }

    private boolean expectedNumberOfSides(GrowQueue_I32 splits) {
        for (int j = 0; j < this.numberOfSides.length; ++j) {
            if (this.numberOfSides[j] != splits.size()) continue;
            return true;
        }
        return false;
    }

    private void removeDistortionFromContour(List<Point2D_I32> contour) {
        for (int j = 0; j < contour.size(); ++j) {
            Point2D_I32 p = contour.get(j);
            this.toUndistorted.compute(p.x, p.y);
            p.x = Math.round(this.toUndistorted.distX);
            p.y = Math.round(this.toUndistorted.distY);
        }
    }

    protected final boolean touchesBorder(List<Point2D_I32> contour) {
        int endX = this.labeled.width - 1;
        int endY = this.labeled.height - 1;
        for (int j = 0; j < contour.size(); ++j) {
            Point2D_I32 p = contour.get(j);
            if (p.x != 0 && p.y != 0 && p.x != endX && p.y != endY) continue;
            return true;
        }
        return false;
    }

    public ImageSInt32 getLabeled() {
        return this.labeled;
    }

    public boolean isOutputClockwise() {
        return this.outputClockwise;
    }

    public FastQueue<Polygon2D_F64> getFound() {
        return this.found;
    }

    public List<Contour> getFoundContours() {
        return this.foundContours;
    }

    public Class<T> getInputType() {
        return this.inputType;
    }

    public void setNumberOfSides(int[] numberOfSides) {
        this.numberOfSides = numberOfSides;
    }

    public int[] getNumberOfSides() {
        return this.numberOfSides;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isCheckEdgeBefore() {
        return this.checkEdgeBefore;
    }

    public void setCheckEdgeBefore(boolean checkEdgeBefore) {
        this.checkEdgeBefore = checkEdgeBefore;
    }
}

