/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import boofcv.alg.shapes.corner.RefineCornerLinesToImage;
import boofcv.alg.shapes.edge.SnapToEdge;
import boofcv.alg.shapes.polygon.UtilShapePolygon;
import boofcv.struct.image.ImageSingleBand;
import georegression.geometry.UtilPolygons2D_I32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Polygon2D_I32;
import java.util.List;
import org.ddogleg.struct.GrowQueue_I32;

public class RefinePolygonCornersToImage<T extends ImageSingleBand> {
    private int pixelsAway;
    private boolean insideBlack;
    protected RefineCornerLinesToImage<T> refineCorner;
    protected Point2D_F64 cornerPt = new Point2D_F64();
    protected Point2D_F64 leftPt = new Point2D_F64();
    protected Point2D_F64 rightPt = new Point2D_F64();
    protected List<Point2D_I32> contour;
    protected GrowQueue_I32 splits;
    Polygon2D_I32 poly = new Polygon2D_I32();

    public RefinePolygonCornersToImage(int endPointDistance, boolean insideBlack, double cornerOffset, int maxLineSamples, int sampleRadius, int maxIterations, double convergeTolPixels, Class<T> imageType) {
        this.pixelsAway = endPointDistance;
        this.insideBlack = insideBlack;
        this.refineCorner = new RefineCornerLinesToImage<T>(cornerOffset, maxLineSamples, sampleRadius, maxIterations, convergeTolPixels, true, imageType);
    }

    public RefinePolygonCornersToImage(boolean positiveRight, Class<T> imageType) {
        this(12, positiveRight, 2.0, 10, 1, 10, 1.0E-6, imageType);
    }

    public void setImage(T input) {
        this.refineCorner.setImage(input);
    }

    public int refine(List<Point2D_I32> contour, GrowQueue_I32 splits, Polygon2D_F64 refined) {
        if (refined.size() != splits.size()) {
            throw new IllegalArgumentException("Miss match between number of splits and polygon order");
        }
        this.contour = contour;
        this.splits = splits;
        int dir = this.determineDirection(contour, splits);
        int numGood = 0;
        for (int cornerS = 0; cornerS < splits.size(); ++cornerS) {
            int indexLeft = this.pickEndIndex(cornerS, dir);
            int indexRight = this.pickEndIndex(cornerS, -dir);
            Point2D_I32 contourCorner = contour.get(splits.get(cornerS));
            Point2D_I32 contourLeft = contour.get(indexLeft);
            Point2D_I32 contourRight = contour.get(indexRight);
            this.cornerPt.set((double)contourCorner.x, (double)contourCorner.y);
            this.leftPt.set((double)contourLeft.x, (double)contourLeft.y);
            this.rightPt.set((double)contourRight.x, (double)contourRight.y);
            if (this.refineCorner.refine(this.cornerPt, this.leftPt, this.rightPt)) {
                refined.get(cornerS).set(this.refineCorner.getRefinedCorner());
                ++numGood;
                continue;
            }
            refined.get(cornerS).set(this.cornerPt);
        }
        return numGood;
    }

    protected int determineDirection(List<Point2D_I32> contour, GrowQueue_I32 splits) {
        this.poly.vertexes.resize(splits.size);
        for (int i = 0; i < splits.size(); ++i) {
            ((Point2D_I32)this.poly.vertexes.get(i)).set(contour.get(splits.get(i)));
        }
        boolean ccw = UtilPolygons2D_I32.isCCW((List)this.poly.vertexes.toList());
        int dir = ccw ? (this.insideBlack ? -1 : 1) : (this.insideBlack ? 1 : -1);
        return dir;
    }

    protected int pickEndIndex(int cornerS, int dir) {
        int endIndex;
        int cornerIndex = this.splits.get(cornerS);
        int distance = UtilShapePolygon.subtract(cornerIndex, endIndex = this.splits.get(UtilShapePolygon.addOffset(cornerS, dir, this.splits.size)), this.contour.size());
        distance = distance > 0 ? Math.min(distance, this.pixelsAway) : Math.max(distance, -this.pixelsAway);
        return UtilShapePolygon.addOffset(cornerIndex, distance, this.contour.size());
    }

    public int getPixelsAway() {
        return this.pixelsAway;
    }

    public void setPixelsAway(int pixelsAway) {
        this.pixelsAway = pixelsAway;
    }

    public boolean isInsideBlack() {
        return this.insideBlack;
    }

    public void setInsideBlack(boolean insideBlack) {
        this.insideBlack = insideBlack;
    }

    public SnapToEdge<T> getSnapToEdge() {
        return this.refineCorner.getSnapToEdge();
    }
}

