/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import boofcv.alg.shapes.edge.SnapToEdge;
import boofcv.alg.shapes.polygon.UtilShapePolygon;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;

public class RefinePolygonLineToImage<T extends ImageSingleBand> {
    double cornerOffset = 2.0;
    private int maxIterations = 10;
    private double convergeTolPixels = 0.01;
    private boolean fitBlack = true;
    private SnapToEdge<T> snapToEdge;
    private LineGeneral2D_F64[] general = new LineGeneral2D_F64[0];
    private Polygon2D_F64 previous;
    private Point2D_F64 adjA = new Point2D_F64();
    private Point2D_F64 adjB = new Point2D_F64();
    protected T image;
    Class<T> imageType;

    public RefinePolygonLineToImage(double cornerOffset, int lineSamples, int sampleRadius, int maxIterations, double convergeTolPixels, boolean fitBlack, Class<T> imageType) {
        this.cornerOffset = cornerOffset;
        this.maxIterations = maxIterations;
        this.convergeTolPixels = convergeTolPixels;
        this.snapToEdge = new SnapToEdge<T>(lineSamples, sampleRadius, imageType);
        this.imageType = imageType;
        this.fitBlack = fitBlack;
        this.previous = new Polygon2D_F64(1);
    }

    public RefinePolygonLineToImage(int numSides, boolean fitBlack, Class<T> imageType) {
        this.previous = new Polygon2D_F64(numSides);
        this.imageType = imageType;
        this.snapToEdge = new SnapToEdge<T>(20, 1, imageType);
        this.fitBlack = fitBlack;
    }

    public void setImage(T image) {
        this.image = image;
        this.snapToEdge.setImage(image);
    }

    public boolean refine(Polygon2D_F64 input, Polygon2D_F64 output) {
        if (input.size() != output.size()) {
            throw new IllegalArgumentException("Input and output sides do not match. " + input.size() + " " + output.size());
        }
        if (input.isCCW()) {
            throw new IllegalArgumentException("Polygon must be in clockwise order");
        }
        if (this.checkShapeTooSmall(input)) {
            return false;
        }
        if (this.general.length < input.size()) {
            this.general = new LineGeneral2D_F64[input.size()];
            for (int i = 0; i < this.general.length; ++i) {
                this.general[i] = new LineGeneral2D_F64();
            }
        }
        return this.optimize(input, output);
    }

    private boolean checkShapeTooSmall(Polygon2D_F64 input) {
        double minLength = this.cornerOffset * 2.0 + 2.0;
        for (int i = 0; i < input.size(); ++i) {
            Point2D_F64 b;
            int j = (i + 1) % input.size();
            Point2D_F64 a = input.get(i);
            if (!(a.distance2((GeoTuple2D_F64)(b = input.get(j))) < minLength * minLength)) continue;
            return true;
        }
        return false;
    }

    protected boolean optimize(Polygon2D_F64 seed, Polygon2D_F64 current) {
        this.previous.set(seed);
        double convergeTol = this.convergeTolPixels * this.convergeTolPixels;
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            for (int i = 0; i < this.previous.size(); ++i) {
                Point2D_F64 b;
                int j = (i + 1) % this.previous.size();
                Point2D_F64 a = this.previous.get(i);
                if (this.optimize(a, b = this.previous.get(j), this.general[i])) continue;
                return false;
            }
            if (!UtilShapePolygon.convert(this.general, current)) {
                return false;
            }
            boolean converged = true;
            for (int i = 0; i < current.size(); ++i) {
                if (!(current.get(i).distance2((GeoTuple2D_F64)this.previous.get(i)) > convergeTol)) continue;
                converged = false;
                break;
            }
            if (converged) break;
            this.previous.set(current);
        }
        return true;
    }

    protected boolean optimize(Point2D_F64 a, Point2D_F64 b, LineGeneral2D_F64 found) {
        double slopeX = b.x - a.x;
        double slopeY = b.y - a.y;
        double r = Math.sqrt(slopeX * slopeX + slopeY * slopeY);
        double unitX = slopeX / r;
        double unitY = slopeY / r;
        this.adjA.x = a.x + unitX * this.cornerOffset;
        this.adjA.y = a.y + unitY * this.cornerOffset;
        this.adjB.x = b.x - unitX * this.cornerOffset;
        this.adjB.y = b.y - unitY * this.cornerOffset;
        if (this.fitBlack) {
            return this.snapToEdge.refine(this.adjA, this.adjB, found);
        }
        return this.snapToEdge.refine(this.adjB, this.adjA, found);
    }

    public SnapToEdge<T> getSnapToEdge() {
        return this.snapToEdge;
    }

    public boolean isFitBlack() {
        return this.fitBlack;
    }
}

