/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;

public class UtilShapePolygon {
    public static boolean convert(LineGeneral2D_F64[] lines, Polygon2D_F64 poly) {
        for (int i = 0; i < poly.size(); ++i) {
            int j = (i + 1) % poly.size();
            if (null != Intersection2D_F64.intersection((LineGeneral2D_F64)lines[i], (LineGeneral2D_F64)lines[j], (Point2D_F64)poly.get(j))) continue;
            return false;
        }
        return true;
    }

    public static int plusPOffset(int index, int offset, int size) {
        return (index + offset) % size;
    }

    public static int minusPOffset(int index, int offset, int size) {
        if ((index -= offset) < 0) {
            return size + index;
        }
        return index;
    }

    public static int addOffset(int index, int offset, int size) {
        if ((index += offset) < 0) {
            return size + index;
        }
        return index % size;
    }

    public static int distanceP(int index0, int index1, int size) {
        int difference = index1 - index0;
        if (difference < 0) {
            difference = size + difference;
        }
        return difference;
    }

    public static int subtract(int index0, int index1, int size) {
        int distance = UtilShapePolygon.distanceP(index0, index1, size);
        if (distance >= size / 2 + size % 2) {
            return distance - size;
        }
        return distance;
    }
}

