/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.background;

import boofcv.alg.background.moving.BackgroundMovingBasic;
import boofcv.alg.background.moving.BackgroundMovingBasic_IL;
import boofcv.alg.background.moving.BackgroundMovingBasic_MS;
import boofcv.alg.background.moving.BackgroundMovingBasic_SB;
import boofcv.alg.background.moving.BackgroundMovingGaussian;
import boofcv.alg.background.moving.BackgroundMovingGaussian_IL;
import boofcv.alg.background.moving.BackgroundMovingGaussian_MS;
import boofcv.alg.background.moving.BackgroundMovingGaussian_SB;
import boofcv.alg.background.stationary.BackgroundStationaryBasic;
import boofcv.alg.background.stationary.BackgroundStationaryBasic_IL;
import boofcv.alg.background.stationary.BackgroundStationaryBasic_MS;
import boofcv.alg.background.stationary.BackgroundStationaryBasic_SB;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian_IL;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian_MS;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian_SB;
import boofcv.factory.background.ConfigBackgroundBasic;
import boofcv.factory.background.ConfigBackgroundGaussian;
import boofcv.struct.distort.PointTransformModel_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.InvertibleTransform;

public class FactoryBackgroundModel {
    public static <T extends ImageBase> BackgroundStationaryBasic<T> stationaryBasic(ConfigBackgroundBasic config, ImageType<T> imageType) {
        config.checkValidity();
        switch (imageType.getFamily()) {
            case SINGLE_BAND: {
                return new BackgroundStationaryBasic_SB(config.learnRate, config.threshold, imageType.getImageClass());
            }
            case MULTI_SPECTRAL: {
                return new BackgroundStationaryBasic_MS(config.learnRate, config.threshold, imageType);
            }
            case INTERLEAVED: {
                return new BackgroundStationaryBasic_IL<T>(config.learnRate, config.threshold, imageType);
            }
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <T extends ImageBase, Motion extends InvertibleTransform<Motion>> BackgroundMovingBasic<T, Motion> movingBasic(ConfigBackgroundBasic config, PointTransformModel_F32<Motion> transform, ImageType<T> imageType) {
        config.checkValidity();
        switch (imageType.getFamily()) {
            case SINGLE_BAND: {
                return new BackgroundMovingBasic_SB(config.learnRate, config.threshold, transform, config.interpolation, imageType.getImageClass());
            }
            case MULTI_SPECTRAL: {
                return new BackgroundMovingBasic_MS(config.learnRate, config.threshold, transform, config.interpolation, imageType);
            }
            case INTERLEAVED: {
                return new BackgroundMovingBasic_IL<T, Motion>(config.learnRate, config.threshold, transform, config.interpolation, imageType);
            }
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <T extends ImageBase> BackgroundStationaryGaussian<T> stationaryGaussian(ConfigBackgroundGaussian config, ImageType<T> imageType) {
        BackgroundStationaryGaussian ret;
        config.checkValidity();
        switch (imageType.getFamily()) {
            case SINGLE_BAND: {
                ret = new BackgroundStationaryGaussian_SB(config.learnRate, config.threshold, imageType.getImageClass());
                break;
            }
            case MULTI_SPECTRAL: {
                ret = new BackgroundStationaryGaussian_MS(config.learnRate, config.threshold, imageType);
                break;
            }
            case INTERLEAVED: {
                ret = new BackgroundStationaryGaussian_IL<T>(config.learnRate, config.threshold, imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image type");
            }
        }
        ret.setInitialVariance(config.initialVariance);
        ret.setMinimumDifference(config.minimumDifference);
        return ret;
    }

    public static <T extends ImageBase, Motion extends InvertibleTransform<Motion>> BackgroundMovingGaussian<T, Motion> movingGaussian(ConfigBackgroundGaussian config, PointTransformModel_F32<Motion> transform, ImageType<T> imageType) {
        BackgroundMovingGaussian ret;
        config.checkValidity();
        switch (imageType.getFamily()) {
            case SINGLE_BAND: {
                ret = new BackgroundMovingGaussian_SB(config.learnRate, config.threshold, transform, config.interpolation, imageType.getImageClass());
                break;
            }
            case MULTI_SPECTRAL: {
                ret = new BackgroundMovingGaussian_MS(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                break;
            }
            case INTERLEAVED: {
                ret = new BackgroundMovingGaussian_IL<T, Motion>(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image type");
            }
        }
        ret.setInitialVariance(config.initialVariance);
        ret.setMinimumDifference(config.minimumDifference);
        return ret;
    }
}

