/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.describe;

import boofcv.abst.feature.describe.ConfigSiftDescribe;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.filter.blur.BlurFilter;
import boofcv.alg.feature.describe.DescribePointBinaryCompare;
import boofcv.alg.feature.describe.DescribePointBrief;
import boofcv.alg.feature.describe.DescribePointBriefSO;
import boofcv.alg.feature.describe.DescribePointPixelRegion;
import boofcv.alg.feature.describe.DescribePointPixelRegionNCC;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.describe.DescribePointSurfMod;
import boofcv.alg.feature.describe.DescribePointSurfMultiSpectral;
import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import boofcv.alg.feature.describe.impl.ImplDescribeBinaryCompare_F32;
import boofcv.alg.feature.describe.impl.ImplDescribeBinaryCompare_U8;
import boofcv.alg.feature.describe.impl.ImplDescribePointPixelRegionNCC_F32;
import boofcv.alg.feature.describe.impl.ImplDescribePointPixelRegionNCC_U8;
import boofcv.alg.feature.describe.impl.ImplDescribePointPixelRegion_F32;
import boofcv.alg.feature.describe.impl.ImplDescribePointPixelRegion_U8;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;

public class FactoryDescribePointAlgs {
    public static <T extends ImageSingleBand> DescribePointSurf<T> surfSpeed(ConfigSurfDescribe.Speed config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigSurfDescribe.Speed();
        }
        config.checkValidity();
        return new DescribePointSurf<T>(config.widthLargeGrid, config.widthSubRegion, config.widthSample, config.weightSigma, config.useHaar, imageType);
    }

    public static <T extends ImageSingleBand> DescribePointSurfMod<T> surfStability(ConfigSurfDescribe.Stability config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigSurfDescribe.Stability();
        }
        config.checkValidity();
        return new DescribePointSurfMod<T>(config.widthLargeGrid, config.widthSubRegion, config.widthSample, config.overLap, config.sigmaLargeGrid, config.sigmaSubRegion, config.useHaar, imageType);
    }

    public static <T extends ImageSingleBand> DescribePointSurfMultiSpectral<T> surfColor(DescribePointSurf<T> describe, int numBands) {
        return new DescribePointSurfMultiSpectral<T>(describe, numBands);
    }

    public static <T extends ImageSingleBand> DescribePointBrief<T> brief(BinaryCompareDefinition_I32 definition, BlurFilter<T> filterBlur) {
        DescribePointBinaryCompare compare;
        Class imageType = filterBlur.getInputType().getImageClass();
        if (imageType == ImageFloat32.class) {
            compare = new ImplDescribeBinaryCompare_F32(definition);
        } else if (imageType == ImageUInt8.class) {
            compare = new ImplDescribeBinaryCompare_U8(definition);
        } else {
            throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
        }
        return new DescribePointBrief<ImageFloat32>(compare, filterBlur);
    }

    public static <T extends ImageSingleBand> DescribePointBriefSO<T> briefso(BinaryCompareDefinition_I32 definition, BlurFilter<T> filterBlur) {
        Class imageType = filterBlur.getInputType().getImageClass();
        InterpolatePixelS interp = FactoryInterpolation.bilinearPixelS((Class)imageType, (BorderType)BorderType.EXTENDED);
        return new DescribePointBriefSO<T>(definition, filterBlur, interp);
    }

    public static DescribePointSift sift(ConfigSiftDescribe config) {
        if (config == null) {
            config = new ConfigSiftDescribe();
        }
        config.checkValidity();
        return new DescribePointSift(config.gridWidth, config.numSamples, config.numHistBins, config.weightSigma, config.sigmaToRadius);
    }

    public static <T extends ImageSingleBand, D extends TupleDesc> DescribePointPixelRegion<T, D> pixelRegion(int regionWidth, int regionHeight, Class<T> imageType) {
        if (imageType == ImageFloat32.class) {
            return new ImplDescribePointPixelRegion_F32(regionWidth, regionHeight);
        }
        if (imageType == ImageUInt8.class) {
            return new ImplDescribePointPixelRegion_U8(regionWidth, regionHeight);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }

    public static <T extends ImageSingleBand> DescribePointPixelRegionNCC<T> pixelRegionNCC(int regionWidth, int regionHeight, Class<T> imageType) {
        if (imageType == ImageFloat32.class) {
            return new ImplDescribePointPixelRegionNCC_F32(regionWidth, regionHeight);
        }
        if (imageType == ImageUInt8.class) {
            return new ImplDescribePointPixelRegionNCC_U8(regionWidth, regionHeight);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }
}

