/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.shape;

import boofcv.factory.shape.ConfigRefinePolygonCornersToImage;
import boofcv.factory.shape.ConfigRefinePolygonLineToImage;
import boofcv.struct.Configuration;

public class ConfigPolygonDetector
implements Configuration {
    public int[] numberOfSides = null;
    public double contour2Poly_mergeTolerance = 0.1;
    public int contour2Poly_iterations = 20;
    public double contour2Poly_splitDistanceFraction = 0.04;
    public boolean refineWithLines = true;
    public boolean refineWithCorners = false;
    public double minimumEdgeIntensity = 3.0;
    public double minContourImageWidthFraction = 0.05;
    public boolean clockwise = true;
    public ConfigRefinePolygonLineToImage configRefineLines = new ConfigRefinePolygonLineToImage();
    public ConfigRefinePolygonCornersToImage configRefineCorners = new ConfigRefinePolygonCornersToImage();

    public ConfigPolygonDetector(int ... numberOfSides) {
        this.numberOfSides = numberOfSides;
    }

    public ConfigPolygonDetector(boolean clockwise, int ... numberOfSides) {
        this.numberOfSides = numberOfSides;
        this.clockwise = clockwise;
    }

    public void checkValidity() {
        if (this.refineWithCorners && this.refineWithLines) {
            throw new IllegalArgumentException("Can't refine with both corners and lines");
        }
        if (this.refineWithLines && !this.configRefineLines.insideBlack) {
            throw new IllegalArgumentException("The detector only support black objects so refine lines fitBlack must be true");
        }
        if (this.refineWithCorners && !this.configRefineCorners.insideBlack) {
            throw new IllegalArgumentException("The detector only support black objects so refine corners fitBlack must be true");
        }
    }

    public String toString() {
        String sides = "[";
        for (int i = 0; i < this.numberOfSides.length; ++i) {
            sides = sides + " " + this.numberOfSides[i];
        }
        sides = sides + " ]";
        return this.getClass().getSimpleName() + "{ numberOfSides=" + sides + " , contour2Poly_mergeTolerance=" + this.contour2Poly_mergeTolerance + " , contour2Poly_iterations=" + this.contour2Poly_iterations + " , contour2Poly_splitDistanceFraction=" + this.contour2Poly_splitDistanceFraction + " , refineWithLines=" + this.refineWithLines + " , refineWithCorners=" + this.refineWithCorners + " , minContourImageWidthFraction=" + this.minContourImageWidthFraction + " , clockwise=" + this.clockwise + " , configRefineLines=" + this.configRefineLines + " , configRefineCorners=" + this.configRefineCorners + " }";
    }
}

