/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.shape;

import boofcv.alg.shapes.edge.PolygonEdgeScore;
import boofcv.alg.shapes.polygon.BinaryPolygonConvexDetector;
import boofcv.alg.shapes.polygon.RefinePolygonCornersToImage;
import boofcv.alg.shapes.polygon.RefinePolygonLineToImage;
import boofcv.alg.shapes.polyline.SplitMergeLineFitLoop;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.struct.image.ImageSingleBand;

public class FactoryShapeDetector {
    public static <T extends ImageSingleBand> BinaryPolygonConvexDetector<T> polygon(ConfigPolygonDetector config, Class<T> imageType) {
        config.checkValidity();
        SplitMergeLineFitLoop contourToPolygon = new SplitMergeLineFitLoop(0.0, config.contour2Poly_mergeTolerance, config.contour2Poly_iterations);
        RefinePolygonLineToImage<T> refineLine = null;
        if (config.refineWithLines) {
            refineLine = new RefinePolygonLineToImage<T>(config.configRefineLines.cornerOffset, config.configRefineLines.lineSamples, config.configRefineLines.sampleRadius, config.configRefineLines.maxIterations, config.configRefineLines.convergeTolPixels, true, imageType);
        }
        RefinePolygonCornersToImage<T> refineCorner = null;
        if (config.refineWithCorners) {
            refineCorner = new RefinePolygonCornersToImage<T>(config.configRefineCorners.endPointDistance, true, config.configRefineCorners.cornerOffset, config.configRefineCorners.lineSamples, config.configRefineCorners.sampleRadius, config.configRefineCorners.maxIterations, config.configRefineCorners.convergeTolPixels, imageType);
        }
        PolygonEdgeScore<T> scorer = null;
        if (config.minimumEdgeIntensity > 0.0) {
            if (config.refineWithLines) {
                scorer = new PolygonEdgeScore<T>(config.configRefineLines.cornerOffset, config.configRefineLines.sampleRadius, config.configRefineLines.lineSamples, config.minimumEdgeIntensity, imageType);
            } else if (config.refineWithCorners) {
                scorer = new PolygonEdgeScore<T>(config.configRefineCorners.cornerOffset, config.configRefineCorners.sampleRadius, config.configRefineCorners.lineSamples * 2, config.minimumEdgeIntensity, imageType);
            }
        }
        return new BinaryPolygonConvexDetector<T>(config.numberOfSides, contourToPolygon, scorer, refineLine, refineCorner, config.minContourImageWidthFraction, config.contour2Poly_splitDistanceFraction, config.clockwise, imageType);
    }
}

