/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.dense;

import boofcv.abst.feature.dense.DescribeImageDense;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.FastQueue;

public class GenericDenseDescribeImageDense<T extends ImageBase, Desc extends TupleDesc>
implements DescribeImageDense<T, Desc> {
    DescribeRegionPoint<T, Desc> alg;
    double scale;
    int featureWidth;
    int periodX;
    int periodY;

    public GenericDenseDescribeImageDense(DescribeRegionPoint<T, Desc> alg, double scale, int featureWidth, int periodX, int periodY) {
        this.alg = alg;
        this.scale = scale;
        this.featureWidth = featureWidth;
        this.periodX = periodX;
        this.periodY = periodY;
    }

    @Override
    public void process(T input, FastQueue<Desc> descriptions, FastQueue<Point2D_I32> locations) {
        this.alg.setImage(input);
        int x0 = this.featureWidth / 2;
        int x1 = input.getWidth() - this.featureWidth / 2;
        int y0 = this.featureWidth / 2;
        int y1 = input.getHeight() - this.featureWidth / 2;
        for (int y = y0; y < y1; y += this.periodY) {
            for (int x = x0; x < x1; x += this.periodX) {
                TupleDesc d = (TupleDesc)descriptions.grow();
                if (!this.alg.process(x, y, 0.0, this.scale, d)) {
                    descriptions.removeTail();
                    continue;
                }
                if (locations == null) continue;
                ((Point2D_I32)locations.grow()).set(x, y);
            }
        }
    }

    @Override
    public ImageType<T> getImageType() {
        return this.alg.getImageType();
    }

    @Override
    public Desc createDescription() {
        return this.alg.createDescription();
    }

    @Override
    public Class<Desc> getDescriptionType() {
        return this.alg.getDescriptionType();
    }
}

