/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.flow;

import boofcv.abst.flow.DenseOpticalFlow;
import boofcv.alg.flow.DenseOpticalFlowBlockPyramid;
import boofcv.alg.flow.UtilDenseOpticalFlow;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ImagePyramid;

public class FlowBlock_to_DenseOpticalFlow<T extends ImageSingleBand>
implements DenseOpticalFlow<T> {
    DenseOpticalFlowBlockPyramid<T> flowAlg;
    int width = -1;
    int height = -1;
    double scale;
    int maxLayers;
    ImagePyramid<T> pyramidSrc;
    ImagePyramid<T> pyramidDst;
    ImageType<T> imageType;

    public FlowBlock_to_DenseOpticalFlow(DenseOpticalFlowBlockPyramid<T> flowAlg, double scale, int maxLayers, Class<T> imageType) {
        this.flowAlg = flowAlg;
        this.scale = scale;
        this.maxLayers = maxLayers;
        this.imageType = ImageType.single(imageType);
    }

    @Override
    public void process(T source, T destination, ImageFlow flow) {
        if (this.width != ((ImageSingleBand)source).width || this.height != ((ImageSingleBand)source).height) {
            this.width = ((ImageSingleBand)source).width;
            this.height = ((ImageSingleBand)source).height;
            int minSize = 2 * (this.flowAlg.getRegionRadius() + this.flowAlg.getRegionRadius() + 1) + 1;
            this.pyramidSrc = UtilDenseOpticalFlow.standardPyramid(((ImageSingleBand)source).width, ((ImageSingleBand)source).height, this.scale, 0.0, minSize, this.maxLayers, source.getImageType().getImageClass());
            this.pyramidDst = UtilDenseOpticalFlow.standardPyramid(((ImageSingleBand)source).width, ((ImageSingleBand)source).height, this.scale, 0.0, minSize, this.maxLayers, source.getImageType().getImageClass());
        }
        this.pyramidSrc.process(source);
        this.pyramidDst.process(destination);
        this.flowAlg.process(this.pyramidSrc, this.pyramidDst);
        flow.setTo(this.flowAlg.getOpticalFlow());
    }

    @Override
    public ImageType<T> getInputType() {
        return this.imageType;
    }
}

