/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detdesc;

import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.feature.detect.interest.SiftImageScaleSpace;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.feature.SurfFeature;
import boofcv.struct.feature.SurfFeatureQueue;
import boofcv.struct.image.ImageFloat32;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;

public class DetectDescribeSift {
    protected SiftImageScaleSpace ss;
    protected SiftDetector detector;
    protected OrientationHistogramSift orientation;
    protected DescribePointSift describe;
    protected SurfFeatureQueue features;
    protected GrowQueue_F64 featureScales;
    protected GrowQueue_F64 featureAngles;
    protected FastQueue<Point2D_F64> location;

    public DetectDescribeSift(SiftImageScaleSpace ss, SiftDetector detector, OrientationHistogramSift orientation, DescribePointSift describe) {
        this.ss = ss;
        this.detector = detector;
        this.orientation = orientation;
        this.describe = describe;
        this.features = new SurfFeatureQueue(describe.getDescriptorLength());
        this.featureScales = new GrowQueue_F64(100);
        this.featureAngles = new GrowQueue_F64(100);
        this.location = new FastQueue(100, Point2D_F64.class, true);
    }

    public void process(ImageFloat32 input) {
        this.features.reset();
        this.featureScales.reset();
        this.featureAngles.reset();
        this.location.reset();
        this.ss.constructPyramid(input);
        this.ss.computeFeatureIntensity();
        this.ss.computeDerivatives();
        this.detector.process(this.ss);
        this.orientation.setScaleSpace(this.ss);
        this.describe.setScaleSpace(this.ss);
        FastQueue<ScalePoint> found = this.detector.getFoundPoints();
        for (int i = 0; i < found.size; ++i) {
            ScalePoint sp = ((ScalePoint[])found.data)[i];
            this.orientation.process(sp.x, sp.y, sp.scale);
            GrowQueue_F64 angles = this.orientation.getOrientations();
            int imageIndex = this.orientation.getImageIndex();
            double pixelScale = this.orientation.getPixelScale();
            for (int j = 0; j < angles.size; ++j) {
                SurfFeature desc = (SurfFeature)this.features.grow();
                double yaw = angles.data[j];
                this.describe.process(sp.x, sp.y, sp.scale, yaw, imageIndex, pixelScale, desc);
                desc.laplacianPositive = sp.white;
                this.featureScales.push(sp.scale);
                this.featureAngles.push(yaw);
                ((Point2D_F64)this.location.grow()).set(sp.x, sp.y);
            }
        }
    }

    public int getDescriptorLength() {
        return this.describe.getDescriptorLength();
    }

    public SurfFeatureQueue getFeatures() {
        return this.features;
    }

    public GrowQueue_F64 getFeatureScales() {
        return this.featureScales;
    }

    public GrowQueue_F64 getFeatureAngles() {
        return this.featureAngles;
    }

    public FastQueue<Point2D_F64> getLocation() {
        return this.location;
    }
}

