/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.alg.feature.detect.extract.NonMaxBlock;
import boofcv.struct.image.ImageFloat32;
import georegression.struct.point.Point2D_I32;

public abstract class NonMaxBlockRelaxed
extends NonMaxBlock {
    Point2D_I32[] foundMax;
    Point2D_I32[] foundMin;

    protected NonMaxBlockRelaxed(boolean detectsMinimum, boolean detectsMaximum) {
        super(detectsMinimum, detectsMaximum);
    }

    protected void checkLocalMax(int x_c, int y_c, float peakVal, ImageFloat32 img) {
        int x0 = x_c - this.radius;
        int x1 = x_c + this.radius;
        int y0 = y_c - this.radius;
        int y1 = y_c + this.radius;
        if (x0 < this.border) {
            x0 = this.border;
        }
        if (y0 < this.border) {
            y0 = this.border;
        }
        if (x1 >= this.endX) {
            x1 = this.endX - 1;
        }
        if (y1 >= this.endY) {
            y1 = this.endY - 1;
        }
        for (int y = y0; y <= y1; ++y) {
            int index = img.startIndex + y * img.stride + x0;
            for (int x = x0; x <= x1; ++x) {
                int n = index++;
                float v = img.data[n];
                if (!(v > peakVal)) continue;
                return;
            }
        }
        this.localMax.add(x_c, y_c);
    }

    protected void checkLocalMin(int x_c, int y_c, float peakVal, ImageFloat32 img) {
        int x0 = x_c - this.radius;
        int x1 = x_c + this.radius;
        int y0 = y_c - this.radius;
        int y1 = y_c + this.radius;
        if (x0 < this.border) {
            x0 = this.border;
        }
        if (y0 < this.border) {
            y0 = this.border;
        }
        if (x1 >= this.endX) {
            x1 = this.endX - 1;
        }
        if (y1 >= this.endY) {
            y1 = this.endY - 1;
        }
        for (int y = y0; y <= y1; ++y) {
            int index = img.startIndex + y * img.stride + x0;
            for (int x = x0; x <= x1; ++x) {
                int n = index++;
                float v = img.data[n];
                if (!(v < peakVal)) continue;
                return;
            }
        }
        this.localMin.add(x_c, y_c);
    }

    @Override
    public void setSearchRadius(int radius) {
        int i;
        super.setSearchRadius(radius);
        int w = 2 * radius + 1;
        this.foundMax = new Point2D_I32[w * w];
        for (i = 0; i < this.foundMax.length; ++i) {
            this.foundMax[i] = new Point2D_I32();
        }
        this.foundMin = new Point2D_I32[w * w];
        for (i = 0; i < this.foundMin.length; ++i) {
            this.foundMin[i] = new Point2D_I32();
        }
    }

    public static class MinMax
    extends NonMaxBlockRelaxed {
        public MinMax() {
            super(true, true);
        }

        @Override
        protected void searchBlock(int x0, int y0, int x1, int y1, ImageFloat32 img) {
            int i;
            int numMinPeaks = 0;
            float peakMinVal = this.thresholdMin;
            int numMaxPeaks = 0;
            float peakMaxVal = this.thresholdMax;
            for (int y = y0; y < y1; ++y) {
                int index = img.startIndex + y * img.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    int n = index++;
                    float v = img.data[n];
                    if (v < peakMinVal) {
                        peakMinVal = v;
                        this.foundMin[0].set(x, y);
                        numMinPeaks = 1;
                    } else if (v == peakMinVal) {
                        this.foundMin[numMinPeaks++].set(x, y);
                    }
                    if (v > peakMaxVal) {
                        peakMaxVal = v;
                        this.foundMax[0].set(x, y);
                        numMaxPeaks = 1;
                        continue;
                    }
                    if (v != peakMaxVal) continue;
                    this.foundMax[numMaxPeaks++].set(x, y);
                }
            }
            if (numMinPeaks > 0 && peakMinVal != -3.4028235E38f) {
                for (i = 0; i < numMinPeaks; ++i) {
                    Point2D_I32 p = this.foundMin[i];
                    this.checkLocalMin(p.x, p.y, peakMinVal, img);
                }
            }
            if (numMaxPeaks > 0 && peakMaxVal != Float.MAX_VALUE) {
                for (i = 0; i < numMaxPeaks; ++i) {
                    Point2D_I32 p = this.foundMax[i];
                    this.checkLocalMax(p.x, p.y, peakMaxVal, img);
                }
            }
        }
    }

    public static class Min
    extends NonMaxBlockRelaxed {
        public Min() {
            super(true, false);
        }

        @Override
        protected void searchBlock(int x0, int y0, int x1, int y1, ImageFloat32 img) {
            int numPeaks = 0;
            float peakVal = this.thresholdMin;
            for (int y = y0; y < y1; ++y) {
                int index = img.startIndex + y * img.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    int n = index++;
                    float v = img.data[n];
                    if (v < peakVal) {
                        peakVal = v;
                        this.foundMin[0].set(x, y);
                        numPeaks = 1;
                        continue;
                    }
                    if (v != peakVal) continue;
                    this.foundMin[numPeaks++].set(x, y);
                }
            }
            if (numPeaks > 0 && peakVal != -3.4028235E38f) {
                for (int i = 0; i < numPeaks; ++i) {
                    Point2D_I32 p = this.foundMin[i];
                    this.checkLocalMin(p.x, p.y, peakVal, img);
                }
            }
        }
    }

    public static class Max
    extends NonMaxBlockRelaxed {
        public Max() {
            super(false, true);
        }

        @Override
        protected void searchBlock(int x0, int y0, int x1, int y1, ImageFloat32 img) {
            int numPeaks = 0;
            float peakVal = this.thresholdMax;
            for (int y = y0; y < y1; ++y) {
                int index = img.startIndex + y * img.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    int n = index++;
                    float v = img.data[n];
                    if (v > peakVal) {
                        peakVal = v;
                        this.foundMax[0].set(x, y);
                        numPeaks = 1;
                        continue;
                    }
                    if (v != peakVal) continue;
                    this.foundMax[numPeaks++].set(x, y);
                }
            }
            if (numPeaks > 0 && peakVal != Float.MAX_VALUE) {
                for (int i = 0; i < numPeaks; ++i) {
                    Point2D_I32 p = this.foundMax[i];
                    this.checkLocalMax(p.x, p.y, peakVal, img);
                }
            }
        }
    }
}

