/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.filter.convolve.ImageConvolveSparse;
import boofcv.alg.feature.detect.extract.SelectNBestFeatures;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.feature.detect.interest.SiftImageScaleSpace;
import boofcv.alg.filter.kernel.KernelMath;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.factory.filter.convolve.FactoryConvolveSparse;
import boofcv.struct.QueueCorner;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.FastQueue;

public class SiftDetector {
    protected SiftImageScaleSpace ss;
    private NonMaxSuppression extractor;
    private SelectNBestFeatures sortBest;
    private int maxFeatures;
    private QueueCorner foundPositive = new QueueCorner(10);
    private QueueCorner foundNegative = new QueueCorner(10);
    private FastQueue<ScalePoint> foundPoints = new FastQueue(10, ScalePoint.class, true);
    private double octavePixelOffset;
    private double currentSigma;
    private double currentPixelScale;
    private ImageConvolveSparse<ImageFloat32, ?> derivXX;
    private ImageConvolveSparse<ImageFloat32, ?> derivXY;
    private ImageConvolveSparse<ImageFloat32, ?> derivYY;
    private double edgeThreshold;

    public SiftDetector(NonMaxSuppression extractor, int maxFeaturesPerScale, double edgeThreshold) {
        if (!extractor.canDetectMaximums() || !extractor.canDetectMinimums()) {
            throw new IllegalArgumentException("The extractor must be able to detect maximums and minimums");
        }
        this.extractor = extractor;
        if (maxFeaturesPerScale > 0) {
            this.maxFeatures = maxFeaturesPerScale;
            this.sortBest = new SelectNBestFeatures(this.maxFeatures);
        }
        this.createDerivatives();
        this.edgeThreshold = edgeThreshold;
    }

    private void createDerivatives() {
        Kernel2D_F32 kerX = new Kernel2D_F32(3, new float[]{0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f});
        Kernel2D_F32 kerY = new Kernel2D_F32(3, new float[]{0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        Kernel2D_F32 kerXX = KernelMath.convolve2D((Kernel2D_F32)kerX, (Kernel2D_F32)kerX);
        Kernel2D_F32 kerXY = KernelMath.convolve2D((Kernel2D_F32)kerX, (Kernel2D_F32)kerY);
        Kernel2D_F32 kerYY = KernelMath.convolve2D((Kernel2D_F32)kerY, (Kernel2D_F32)kerY);
        this.derivXX = FactoryConvolveSparse.create(ImageFloat32.class, (Kernel2D)kerXX);
        this.derivXY = FactoryConvolveSparse.create(ImageFloat32.class, (Kernel2D)kerXY);
        this.derivYY = FactoryConvolveSparse.create(ImageFloat32.class, (Kernel2D)kerYY);
        ImageBorder border = FactoryImageBorder.singleValue(ImageFloat32.class, (double)0.0);
        this.derivXX.setImageBorder(border);
        this.derivXY.setImageBorder(border);
        this.derivYY.setImageBorder(border);
    }

    public void process(SiftImageScaleSpace ss) {
        this.foundPoints.reset();
        this.ss = ss;
        this.octavePixelOffset = 0.0;
        for (int octave = 0; octave < ss.actualOctaves; ++octave) {
            int indexDOG = octave * (ss.numScales - 1) + 1;
            int indexScale = octave * ss.numScales + 1;
            this.currentPixelScale = ss.pixelScale[octave];
            ss.storage.reshape(ss.scale[indexScale].width, ss.scale[indexScale].height);
            int scale = 1;
            while (scale < ss.numScales - 2) {
                this.derivXX.setImage((ImageSingleBand)ss.scale[indexScale]);
                this.derivXY.setImage((ImageSingleBand)ss.scale[indexScale]);
                this.derivYY.setImage((ImageSingleBand)ss.scale[indexScale]);
                this.currentSigma = ss.computeScaleSigma(octave, scale);
                this.detectFeatures(indexDOG);
                ++scale;
                ++indexScale;
                ++indexDOG;
            }
            this.octavePixelOffset += this.currentPixelScale;
        }
    }

    private void detectFeatures(int indexDOG) {
        this.foundNegative.reset();
        this.foundPositive.reset();
        ImageFloat32 scale0 = this.ss.dog[indexDOG - 1];
        ImageFloat32 scale1 = this.ss.dog[indexDOG];
        ImageFloat32 scale2 = this.ss.dog[indexDOG + 1];
        this.extractor.process(scale1, null, null, this.foundNegative, this.foundPositive);
        this.addFoundFeatures(scale0, scale1, scale2, this.foundNegative, false);
        this.addFoundFeatures(scale0, scale1, scale2, this.foundPositive, true);
    }

    private void addFoundFeatures(ImageFloat32 scale0, ImageFloat32 scale1, ImageFloat32 scale2, QueueCorner found, boolean positive) {
        QueueCorner features;
        if (this.sortBest != null) {
            this.sortBest.process(scale1, found, positive);
            features = this.sortBest.getBestCorners();
        } else {
            features = found;
        }
        float signAdj = positive ? 1.0f : -1.0f;
        int ignoreRadius = this.extractor.getIgnoreBorder();
        int borderX = scale1.width - ignoreRadius - 1;
        int borderY = scale1.height - ignoreRadius - 1;
        for (int i = 0; i < features.size; ++i) {
            float value;
            Point2D_I16 p = ((Point2D_I16[])features.data)[i];
            if (p.x <= ignoreRadius || p.y <= ignoreRadius || p.x >= borderX || p.y >= borderY || !this.isScaleSpaceMax(scale0, scale2, p.x, p.y, value = scale1.unsafe_get((int)p.x, (int)p.y), signAdj) || this.isEdge(p.x, p.y)) continue;
            this.addPoint(scale0, scale1, scale2, p.x, p.y, value, signAdj, positive);
        }
    }

    private void addPoint(ImageFloat32 scale0, ImageFloat32 scale1, ImageFloat32 scale2, short x, short y, float value, float signAdj, boolean white) {
        value *= signAdj;
        float x0 = scale1.unsafe_get(x - 1, (int)y) * signAdj;
        float x2 = scale1.unsafe_get(x + 1, (int)y) * signAdj;
        float y0 = scale1.unsafe_get((int)x, y - 1) * signAdj;
        float y2 = scale1.unsafe_get((int)x, y + 1) * signAdj;
        float s0 = scale0.unsafe_get((int)x, (int)y) * signAdj;
        float s2 = scale2.unsafe_get((int)x, (int)y) * signAdj;
        ScalePoint p = (ScalePoint)((Object)this.foundPoints.grow());
        p.x = this.currentPixelScale * (double)((float)x + FastHessianFeatureDetector.polyPeak(x0, value, x2)) + this.octavePixelOffset;
        p.y = this.currentPixelScale * (double)((float)y + FastHessianFeatureDetector.polyPeak(y0, value, y2)) + this.octavePixelOffset;
        p.scale = this.currentSigma + this.currentPixelScale * (double)this.ss.sigma * (double)FastHessianFeatureDetector.polyPeak(s0, value, s2);
        p.white = white;
    }

    private boolean isScaleSpaceMax(ImageFloat32 scale0, ImageFloat32 scale2, int c_x, int c_y, float value, float signAdj) {
        value *= signAdj;
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                float v = scale0.unsafe_get(c_x + x, c_y + y);
                if (v * signAdj >= value) {
                    return false;
                }
                v = scale2.unsafe_get(c_x + x, c_y + y);
                if (!(v * signAdj >= value)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isEdge(int x, int y) {
        if (this.edgeThreshold <= 0.0) {
            return false;
        }
        double xx = this.derivXX.compute(x, y);
        double xy = this.derivXY.compute(x, y);
        double yy = this.derivYY.compute(x, y);
        double Tr = xx + yy;
        double det = xx * yy - xy * xy;
        double value = Tr * Tr / det;
        double threshold = this.edgeThreshold + 2.0 + 1.0 / this.edgeThreshold;
        return Math.abs(value) > threshold;
    }

    public FastQueue<ScalePoint> getFoundPoints() {
        return this.foundPoints;
    }

    public SiftImageScaleSpace getScaleSpace() {
        return this.ss;
    }
}

