/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.fh04.impl;

import boofcv.alg.segmentation.fh04.FhEdgeWeights;
import boofcv.alg.segmentation.fh04.SegmentFelzenszwalbHuttenlocher04;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.MultiSpectral;
import org.ddogleg.struct.FastQueue;

public class FhEdgeWeights4_MsF32
implements FhEdgeWeights<MultiSpectral<ImageFloat32>> {
    float[] pixelColor;
    int numBands;

    public FhEdgeWeights4_MsF32(int numBands) {
        this.numBands = numBands;
        this.pixelColor = new float[numBands];
    }

    @Override
    public void process(MultiSpectral<ImageFloat32> input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        int y;
        edges.reset();
        int w = input.width - 1;
        int h = input.height - 1;
        for (y = 0; y < h; ++y) {
            int indexSrc = input.startIndex + y * input.stride + 0;
            int indexDst = y * input.width + 0;
            int x = 0;
            while (x < w) {
                float weight1 = 0.0f;
                float weight2 = 0.0f;
                for (int i = 0; i < this.numBands; ++i) {
                    ImageFloat32 band = (ImageFloat32)input.getBand(i);
                    float color0 = band.data[indexSrc];
                    float color1 = band.data[indexSrc + 1];
                    float color2 = band.data[indexSrc + input.stride];
                    float diff1 = color0 - color1;
                    float diff2 = color0 - color2;
                    weight1 += diff1 * diff1;
                    weight2 += diff2 * diff2;
                }
                SegmentFelzenszwalbHuttenlocher04.Edge e1 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
                SegmentFelzenszwalbHuttenlocher04.Edge e2 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
                e1.sortValue = (float)Math.sqrt(weight1);
                e1.indexA = indexDst;
                e1.indexB = indexDst + 1;
                e2.sortValue = (float)Math.sqrt(weight2);
                e2.indexA = indexDst;
                e2.indexB = indexDst + input.width;
                ++x;
                ++indexSrc;
                ++indexDst;
            }
        }
        for (y = 0; y < h; ++y) {
            this.checkAround(w, y, input, edges);
        }
        for (int x = 0; x < w; ++x) {
            this.checkAround(x, h, input, edges);
        }
    }

    private void checkAround(int x, int y, MultiSpectral<ImageFloat32> input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        int indexSrc = input.startIndex + y * input.stride + x;
        int indexA = y * input.width + x;
        for (int i = 0; i < this.numBands; ++i) {
            ImageFloat32 band = (ImageFloat32)input.getBand(i);
            this.pixelColor[i] = band.data[indexSrc];
        }
        this.check(x + 1, y, this.pixelColor, indexA, input, edges);
        this.check(x, y + 1, this.pixelColor, indexA, input, edges);
    }

    private void check(int x, int y, float[] color0, int indexA, MultiSpectral<ImageFloat32> input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        if (!input.isInBounds(x, y)) {
            return;
        }
        int indexSrc = input.startIndex + y * input.stride + x;
        int indexB = y * input.width + x;
        float weight = 0.0f;
        for (int i = 0; i < this.numBands; ++i) {
            ImageFloat32 band = (ImageFloat32)input.getBand(i);
            float color = band.data[indexSrc];
            float diff = color0[i] - color;
            weight += diff * diff;
        }
        SegmentFelzenszwalbHuttenlocher04.Edge e1 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
        e1.sortValue = (float)Math.sqrt(weight);
        e1.indexA = indexA;
        e1.indexB = indexB;
    }

    @Override
    public ImageType<MultiSpectral<ImageFloat32>> getInputType() {
        return ImageType.ms((int)3, ImageFloat32.class);
    }
}

