/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.corner;

import boofcv.alg.shapes.edge.SnapToEdge;
import boofcv.struct.image.ImageSingleBand;
import georegression.metric.Intersection2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Vector2D_F64;

public class RefineCornerLinesToImage<T extends ImageSingleBand> {
    double cornerOffset;
    int maxLineSamples;
    private int maxIterations;
    private double convergeTolPixels;
    private SnapToEdge<T> snapToEdge;
    private Point2D_F64 adjA = new Point2D_F64();
    Point2D_F64 previous = new Point2D_F64();
    Point2D_F64 refined = new Point2D_F64();
    Point2D_F64 _endLeft = new Point2D_F64();
    Point2D_F64 _endRight = new Point2D_F64();
    LineGeneral2D_F64 lineLeft = new LineGeneral2D_F64();
    LineGeneral2D_F64 lineRight = new LineGeneral2D_F64();
    Vector2D_F64 directionLeft = new Vector2D_F64();
    Vector2D_F64 directionRight = new Vector2D_F64();
    protected T image;
    Class<T> imageType;
    double maxCornerChange;

    public RefineCornerLinesToImage(double cornerOffset, int maxLineSamples, int sampleRadius, int maxIterations, double convergeTolPixels, double maxCornerChange, Class<T> imageType) {
        if (sampleRadius < 1) {
            throw new IllegalArgumentException("Sample radius must be >= 1 to work");
        }
        this.cornerOffset = cornerOffset;
        this.maxIterations = maxIterations;
        this.convergeTolPixels = convergeTolPixels;
        this.snapToEdge = new SnapToEdge<T>(maxLineSamples, sampleRadius, imageType);
        this.maxLineSamples = maxLineSamples;
        this.imageType = imageType;
        this.maxCornerChange = maxCornerChange;
    }

    public RefineCornerLinesToImage(Class<T> imageType) {
        this(2.0, 10, 2, 10, 1.0E-5, 4.0, imageType);
    }

    public void setImage(T image) {
        this.image = image;
        this.snapToEdge.setImage(image);
    }

    public boolean refine(Point2D_F64 corner, Point2D_F64 endLeft, Point2D_F64 endRight) {
        this._endLeft.set(endLeft);
        this._endRight.set(endRight);
        this.directionLeft.minus(endLeft, corner);
        this.directionLeft.normalize();
        this.directionRight.minus(endRight, corner);
        this.directionRight.normalize();
        double lengthLeft = corner.distance((GeoTuple2D_F64)endLeft);
        double lengthRight = corner.distance((GeoTuple2D_F64)endRight);
        if (lengthLeft < 2.0 * this.cornerOffset || lengthRight < 2.0 * this.cornerOffset) {
            return false;
        }
        int samplesLeft = Math.min(this.maxLineSamples, (int)Math.ceil(lengthLeft));
        int samplesRight = Math.min(this.maxLineSamples, (int)Math.ceil(lengthRight));
        this.refined.set(corner);
        this.previous.set(corner);
        double convergeTol = this.convergeTolPixels * this.convergeTolPixels;
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            this.snapToEdge.setLineSamples(samplesLeft);
            if (!this.optimize(this.refined, this._endLeft, this.lineLeft)) {
                return false;
            }
            this.snapToEdge.setLineSamples(samplesRight);
            if (!this.optimize(this.refined, this._endRight, this.lineRight)) {
                return false;
            }
            if (null == Intersection2D_F64.intersection((LineGeneral2D_F64)this.lineLeft, (LineGeneral2D_F64)this.lineRight, (Point2D_F64)this.refined)) {
                return false;
            }
            if (this.refined.distance2((GeoTuple2D_F64)this.previous) < convergeTol) break;
            if (this.refined.distance2((GeoTuple2D_F64)this.previous) > this.maxCornerChange * this.maxCornerChange) {
                this.refined.set(this.previous);
                break;
            }
            this.updateEndPoints(lengthLeft, lengthRight);
            this.previous.set(this.refined);
        }
        return true;
    }

    private void updateEndPoints(double lengthLeft, double lengthRight) {
        this.lineLeft.normalize();
        double sgn = this.directionLeft.x * this.lineLeft.B - this.directionLeft.y * this.lineLeft.A > 0.0 ? 1.0 : -1.0;
        this._endLeft.x = this.refined.x + sgn * this.lineLeft.B * lengthLeft;
        this._endLeft.y = this.refined.y - sgn * this.lineLeft.A * lengthLeft;
        this.lineRight.normalize();
        sgn = this.directionRight.x * this.lineRight.B - this.directionRight.y * this.lineRight.A > 0.0 ? 1.0 : -1.0;
        this._endRight.x = this.refined.x + sgn * this.lineRight.B * lengthRight;
        this._endRight.y = this.refined.y - sgn * this.lineRight.A * lengthRight;
    }

    protected boolean optimize(Point2D_F64 a, Point2D_F64 b, LineGeneral2D_F64 found) {
        double slopeX = b.x - a.x;
        double slopeY = b.y - a.y;
        double r = Math.sqrt(slopeX * slopeX + slopeY * slopeY);
        double unitX = slopeX / r;
        double unitY = slopeY / r;
        this.adjA.x = a.x + unitX * this.cornerOffset;
        this.adjA.y = a.y + unitY * this.cornerOffset;
        return this.snapToEdge.refine(this.adjA, b, found);
    }

    public Point2D_F64 getRefinedCorner() {
        return this.refined;
    }

    public Point2D_F64 getRefinedEndLeft() {
        return this._endLeft;
    }

    public Point2D_F64 getRefinedEndRight() {
        return this._endRight;
    }

    public SnapToEdge<T> getSnapToEdge() {
        return this.snapToEdge;
    }
}

