/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.edge;

import boofcv.alg.shapes.edge.ScoreLineSegmentEdge;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;

public class PolygonEdgeScore<T extends ImageSingleBand> {
    private double cornerOffset;
    private double tangentDistance;
    private double thresholdScore;
    private Point2D_F64 offsetA = new Point2D_F64();
    private Point2D_F64 offsetB = new Point2D_F64();
    private double averageEdgeIntensity;
    ScoreLineSegmentEdge<T> scorer;

    public PolygonEdgeScore(double cornerOffset, double tangentDistance, int numSamples, double thresholdScore, Class<T> imageType) {
        this.cornerOffset = cornerOffset;
        this.tangentDistance = tangentDistance;
        this.thresholdScore = thresholdScore;
        this.scorer = new ScoreLineSegmentEdge<T>(numSamples, imageType);
    }

    public void setTransform(PixelTransform_F32 undistToDist) {
        this.scorer.setTransform(undistToDist);
    }

    public void setImage(T image) {
        this.scorer.setImage(image);
    }

    public boolean validate(Polygon2D_F64 polygon) {
        double total = 0.0;
        for (int i = 0; i < polygon.size(); ++i) {
            int j = i + 1;
            if (j == polygon.size()) {
                j = 0;
            }
            Point2D_F64 a = polygon.get(i);
            Point2D_F64 b = polygon.get(j);
            double dx = b.x - a.x;
            double dy = b.y - a.y;
            double t = Math.sqrt(dx * dx + dy * dy);
            dx /= t;
            dy /= t;
            if (t <= 3.0 * this.cornerOffset) {
                return false;
            }
            this.offsetA.x = a.x + this.cornerOffset * dx;
            this.offsetA.y = a.y + this.cornerOffset * dy;
            this.offsetB.x = b.x - this.cornerOffset * dx;
            this.offsetB.y = b.y - this.cornerOffset * dy;
            total += this.scorer.computeAverageDerivative(this.offsetA, this.offsetB, -dy, dx);
        }
        this.averageEdgeIntensity = Math.abs(total) / (double)polygon.size();
        return this.averageEdgeIntensity >= this.thresholdScore;
    }

    public double getCornerOffset() {
        return this.cornerOffset;
    }

    public void setCornerOffset(double cornerOffset) {
        this.cornerOffset = cornerOffset;
    }

    public double getTangentDistance() {
        return this.tangentDistance;
    }

    public void setTangentDistance(double tangentDistance) {
        this.tangentDistance = tangentDistance;
    }

    public double getThresholdScore() {
        return this.thresholdScore;
    }

    public void setThresholdScore(double thresholdScore) {
        this.thresholdScore = thresholdScore;
    }

    public double getAverageEdgeIntensity() {
        return this.averageEdgeIntensity;
    }
}

