/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.edge;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.shapes.edge.BaseIntegralEdge;
import boofcv.core.image.GImageSingleBandDistorted;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;

public class ScoreLineSegmentEdge<T extends ImageSingleBand>
extends BaseIntegralEdge<T> {
    int numSamples;

    public ScoreLineSegmentEdge(int numSamples, Class<T> imageType) {
        super(imageType);
        this.numSamples = numSamples;
    }

    @Override
    public void setTransform(PixelTransform_F32 undistToDist) {
        InterpolatePixelS interpolate = FactoryInterpolation.bilinearPixelS((Class)this.imageType, (BorderType)BorderType.EXTENDED);
        this.integralImage = new GImageSingleBandDistorted(undistToDist, interpolate);
    }

    @Override
    public void setImage(T image) {
        this.integralImage.wrap(image);
        this.integral.setImage(this.integralImage);
    }

    public double computeAverageDerivative(Point2D_F64 a, Point2D_F64 b, double tanX, double tanY) {
        double total = 0.0;
        int samplesInside = 0;
        for (int i = 0; i < this.numSamples; ++i) {
            double x = (b.x - a.x) * (double)i / (double)(this.numSamples - 1) + a.x;
            double y = (b.y - a.y) * (double)i / (double)(this.numSamples - 1) + a.y;
            double x0 = x + tanX;
            double y0 = y + tanY;
            if (!BoofMiscOps.checkInside((int)this.integralImage.getWidth(), (int)this.integralImage.getHeight(), (double)x0, (double)y0)) continue;
            double x1 = x - tanX;
            double y1 = y - tanY;
            if (!BoofMiscOps.checkInside((int)this.integralImage.getWidth(), (int)this.integralImage.getHeight(), (double)x1, (double)y1)) continue;
            ++samplesInside;
            double up = this.integral.compute(x, y, x0, y0);
            double down = this.integral.compute(x, y, x1, y1);
            total += up - down;
        }
        if (samplesInside == 0) {
            return 0.0;
        }
        return total / (double)samplesInside;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }
}

