/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.LinearContourLabelChang2004;
import boofcv.alg.shapes.edge.PolygonEdgeScore;
import boofcv.alg.shapes.polygon.PolygonHelper;
import boofcv.alg.shapes.polygon.RefineBinaryPolygon;
import boofcv.alg.shapes.polyline.MinimizeEnergyPrune;
import boofcv.alg.shapes.polyline.RefinePolyLineCorner;
import boofcv.alg.shapes.polyline.SplitMergeLineFitLoop;
import boofcv.struct.ConnectRule;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.metric.Area2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.RectangleLength2D_F32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class BinaryPolygonDetector<T extends ImageSingleBand> {
    private double minContourFraction;
    private int minimumContour;
    private double minimumArea;
    private boolean convex;
    private LinearContourLabelChang2004 contourFinder = new LinearContourLabelChang2004(ConnectRule.FOUR);
    private ImageSInt32 labeled = new ImageSInt32(1, 1);
    private SplitMergeLineFitLoop fitPolygon;
    GrowQueue_I32 pruned = new GrowQueue_I32();
    MinimizeEnergyPrune pruner;
    private RefinePolyLineCorner improveContour = new RefinePolyLineCorner(true, 20);
    private RefineBinaryPolygon<T> refinePolygon;
    private FastQueue<Polygon2D_F64> found = new FastQueue(Polygon2D_F64.class, true);
    private FastQueue<Info> foundInfo = new FastQueue(Info.class, true);
    private Class<T> inputType;
    private int minSides;
    private int maxSides;
    private boolean canTouchBorder;
    private Polygon2D_F64 workPoly = new Polygon2D_F64();
    private boolean outputClockwise;
    private List<Contour> foundContours = new ArrayList<Contour>();
    protected PixelTransform_F32 toUndistorted;
    protected PixelTransform_F32 toDistorted;
    boolean verbose = false;
    PolygonEdgeScore differenceScore;
    boolean checkEdgeBefore = true;
    private PolygonHelper helper;

    public BinaryPolygonDetector(int minSides, int maxSides, SplitMergeLineFitLoop contourToPolygon, PolygonEdgeScore differenceScore, RefineBinaryPolygon<T> refinePolygon, double minContourFraction, boolean outputClockwise, boolean convex, boolean touchBorder, double splitPenalty, Class<T> inputType) {
        this.setNumberOfSides(minSides, maxSides);
        this.refinePolygon = refinePolygon;
        this.differenceScore = differenceScore;
        this.inputType = inputType;
        this.minContourFraction = minContourFraction;
        this.fitPolygon = contourToPolygon;
        this.outputClockwise = outputClockwise;
        this.convex = convex;
        this.canTouchBorder = touchBorder;
        this.pruner = new MinimizeEnergyPrune(splitPenalty);
        this.workPoly = new Polygon2D_F64(1);
        if (this.canTouchBorder) {
            throw new RuntimeException("CanTouchBorder not supported yet");
        }
    }

    public void setLensDistortion(int width, int height, PixelTransform_F32 toUndistorted, PixelTransform_F32 toDistorted) {
        this.toUndistorted = toUndistorted;
        this.toDistorted = toDistorted;
        RectangleLength2D_F32 rect = DistortImageOps.boundBox_F32((int)width, (int)height, (PixelTransform_F32)toUndistorted);
        float x1 = rect.x0 + rect.width;
        float y1 = rect.y0 + rect.height;
        float tol = 1.0E-4f;
        if (rect.getX() < -tol || rect.getY() < -tol || x1 > (float)width + tol || y1 > (float)height + tol) {
            throw new IllegalArgumentException("You failed the idiot test! RTFM! The undistorted image must be contained by the same bounds as the input distorted image");
        }
        if (this.refinePolygon != null) {
            this.refinePolygon.setLensDistortion(width, height, toUndistorted, toDistorted);
        }
        if (this.differenceScore != null) {
            this.differenceScore.setTransform(toDistorted);
        }
    }

    public void process(T gray, ImageUInt8 binary) {
        if (this.verbose) {
            System.out.println("ENTER  BinaryPolygonDetector.process()");
        }
        InputSanityCheck.checkSameShape((ImageBase)binary, gray);
        if (this.labeled.width != ((ImageSingleBand)gray).width || this.labeled.height == ((ImageSingleBand)gray).width) {
            this.configure(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
        }
        this.found.reset();
        this.foundContours.clear();
        this.foundInfo.reset();
        if (this.differenceScore != null) {
            this.differenceScore.setImage(gray);
        }
        this.findCandidateShapes(gray, binary);
        if (this.verbose) {
            System.out.println("EXIT  BinaryPolygonDetector.process()");
        }
    }

    private void configure(int width, int height) {
        this.labeled.reshape(width, height);
        this.minimumContour = (int)((double)width * this.minContourFraction);
        this.minimumArea = Math.pow((double)this.minimumContour / 4.0, 2.0);
    }

    private void findCandidateShapes(T gray, ImageUInt8 binary) {
        int maxSidesConsider = (int)Math.ceil((double)this.maxSides * 1.5);
        this.fitPolygon.setAbortSplits(2 * this.maxSides);
        this.contourFinder.process(binary, this.labeled);
        FastQueue blobs = this.contourFinder.getContours();
        for (int i = 0; i < blobs.size; ++i) {
            boolean success;
            Contour c = (Contour)blobs.get(i);
            if (c.external.size() < this.minimumContour) continue;
            boolean touchesBorder = this.touchesBorder(c.external);
            if (!this.canTouchBorder && touchesBorder) {
                if (!this.verbose) continue;
                System.out.println("rejected polygon, touched border");
                continue;
            }
            if (this.toUndistorted != null) {
                this.removeDistortionFromContour(c.external);
            }
            if (!this.fitPolygon.process(c.external)) {
                if (!this.verbose) continue;
                System.out.println("rejected polygon initial fit failed. contour size = " + c.external.size());
                continue;
            }
            GrowQueue_I32 splits = this.fitPolygon.getSplits();
            if (splits.size() > maxSidesConsider) {
                if (!this.verbose) continue;
                System.out.println("Way too many corners, " + splits.size() + ". Aborting before improve. Contour size " + c.external.size());
                continue;
            }
            if (!this.improveContour.fit(c.external, splits)) {
                if (!this.verbose) continue;
                System.out.println("rejected improve contour. contour size = " + c.external.size());
                continue;
            }
            this.pruner.prune(c.external, splits, this.pruned);
            splits = this.pruned;
            if (!this.expectedNumberOfSides(splits)) {
                if (!this.verbose) continue;
                System.out.println("rejected number of sides. " + splits.size() + "  contour " + c.external.size());
                continue;
            }
            if (this.helper != null && !this.helper.filterPolygon(c.external, splits)) {
                if (!this.verbose) continue;
                System.out.println("rejected by helper");
                continue;
            }
            this.workPoly.vertexes.resize(splits.size());
            for (int j = 0; j < splits.size(); ++j) {
                Point2D_I32 p = (Point2D_I32)c.external.get(splits.get(j));
                this.workPoly.get(j).set((double)p.x, (double)p.y);
            }
            if (this.helper != null) {
                this.helper.adjustBeforeOptimize(this.workPoly);
            }
            if (this.convex && !UtilPolygons2D_F64.isConvex((Polygon2D_F64)this.workPoly)) {
                if (!this.verbose) continue;
                System.out.println("Rejected not convex");
                continue;
            }
            double area = Area2D_F64.polygonSimple((Polygon2D_F64)this.workPoly);
            if (area < this.minimumArea) {
                if (!this.verbose) continue;
                System.out.println("Rejected area");
                continue;
            }
            if (this.checkEdgeBefore && this.differenceScore != null && !this.differenceScore.validate(this.workPoly)) {
                if (!this.verbose) continue;
                System.out.println("Rejected edge score, after: " + this.differenceScore.getAverageEdgeIntensity());
                continue;
            }
            Polygon2D_F64 refined = (Polygon2D_F64)this.found.grow();
            refined.vertexes.resize(splits.size);
            if (this.refinePolygon != null) {
                this.refinePolygon.setImage(gray);
                success = this.refinePolygon.refine(this.workPoly, c.external, splits, refined);
                if (this.verbose && !success) {
                    System.out.println("Rejected after refinePolygon");
                }
            } else {
                refined.set(this.workPoly);
                success = true;
            }
            if (!this.checkEdgeBefore && this.differenceScore != null && !this.differenceScore.validate(refined)) {
                if (!this.verbose) continue;
                System.out.println("Rejected edge score, after: " + this.differenceScore.getAverageEdgeIntensity());
                continue;
            }
            if (this.outputClockwise == refined.isCCW()) {
                refined.flip();
            }
            if (success) {
                c.id = this.found.size();
                this.foundContours.add(c);
                Info info = (Info)this.foundInfo.grow();
                info.external = true;
                info.touchingBorder = touchesBorder;
                continue;
            }
            this.found.removeTail();
        }
    }

    private boolean expectedNumberOfSides(GrowQueue_I32 splits) {
        return splits.size() >= this.minSides && splits.size() <= this.maxSides;
    }

    private void removeDistortionFromContour(List<Point2D_I32> contour) {
        for (int j = 0; j < contour.size(); ++j) {
            Point2D_I32 p = contour.get(j);
            this.toUndistorted.compute(p.x, p.y);
            p.x = Math.round(this.toUndistorted.distX);
            p.y = Math.round(this.toUndistorted.distY);
        }
    }

    protected final boolean touchesBorder(List<Point2D_I32> contour) {
        int endX = this.labeled.width - 1;
        int endY = this.labeled.height - 1;
        for (int j = 0; j < contour.size(); ++j) {
            Point2D_I32 p = contour.get(j);
            if (p.x != 0 && p.y != 0 && p.x != endX && p.y != endY) continue;
            return true;
        }
        return false;
    }

    public void setHelper(PolygonHelper helper) {
        this.helper = helper;
    }

    public boolean isConvex() {
        return this.convex;
    }

    public void setConvex(boolean convex) {
        this.convex = convex;
    }

    public ImageSInt32 getLabeled() {
        return this.labeled;
    }

    public boolean isOutputClockwise() {
        return this.outputClockwise;
    }

    public FastQueue<Polygon2D_F64> getFoundPolygons() {
        return this.found;
    }

    public List<Contour> getUsedContours() {
        return this.foundContours;
    }

    public List<Contour> getAllContours() {
        return this.contourFinder.getContours().toList();
    }

    public Class<T> getInputType() {
        return this.inputType;
    }

    public void setNumberOfSides(int min, int max) {
        if (min < 3) {
            throw new IllegalArgumentException("The min must be >= 3");
        }
        if (max < min) {
            throw new IllegalArgumentException("The max must be >= the min");
        }
        this.minSides = min;
        this.maxSides = max;
    }

    public int getMinimumSides() {
        return this.minSides;
    }

    public int getMaximumSides() {
        return this.maxSides;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isCheckEdgeBefore() {
        return this.checkEdgeBefore;
    }

    public RefineBinaryPolygon<T> getRefinePolygon() {
        return this.refinePolygon;
    }

    public void setRefinePolygon(RefineBinaryPolygon<T> refinePolygon) {
        this.refinePolygon = refinePolygon;
    }

    public void setCheckEdgeBefore(boolean checkEdgeBefore) {
        this.checkEdgeBefore = checkEdgeBefore;
    }

    public static class Info {
        public boolean touchingBorder;
        public boolean external;
    }
}

