/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.interest;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.intensity.WrapperGradientCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperHessianBlobIntensity;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigSiftDetector;
import boofcv.abst.filter.ImageFunctionSparse;
import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.feature.detect.intensity.HarrisCornerIntensity;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.feature.detect.interest.FeatureLaplacePyramid;
import boofcv.alg.feature.detect.interest.FeaturePyramid;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.filter.derivative.FactoryDerivativeSparse;
import boofcv.struct.image.ImageSingleBand;

public class FactoryInterestPointAlgs {
    public static <T extends ImageSingleBand, D extends ImageSingleBand> FeaturePyramid<T, D> hessianPyramid(int extractRadius, float detectThreshold, int maxFeatures, Class<T> imageType, Class<D> derivType) {
        WrapperHessianBlobIntensity intensity = new WrapperHessianBlobIntensity(HessianBlobIntensity.Type.DETERMINANT, derivType);
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(extractRadius, detectThreshold, extractRadius, true));
        GeneralFeatureDetector detector = new GeneralFeatureDetector(intensity, extractor);
        detector.setMaxFeatures(maxFeatures);
        AnyImageDerivative deriv = GImageDerivativeOps.derivativeForScaleSpace(imageType, derivType);
        return new FeaturePyramid(detector, deriv, 2.0);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> FeaturePyramid<T, D> harrisPyramid(int extractRadius, float detectThreshold, int maxFeatures, Class<T> imageType, Class<D> derivType) {
        HarrisCornerIntensity<D> harris = FactoryIntensityPointAlg.harris(extractRadius, 0.04f, false, derivType);
        WrapperGradientCornerIntensity intensity = new WrapperGradientCornerIntensity(harris);
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(extractRadius, detectThreshold, extractRadius, true));
        GeneralFeatureDetector detector = new GeneralFeatureDetector(intensity, extractor);
        detector.setMaxFeatures(maxFeatures);
        AnyImageDerivative deriv = GImageDerivativeOps.derivativeForScaleSpace(imageType, derivType);
        return new FeaturePyramid(detector, deriv, 2.0);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> FeatureLaplacePyramid<T, D> hessianLaplace(int extractRadius, float detectThreshold, int maxFeatures, Class<T> imageType, Class<D> derivType) {
        WrapperHessianBlobIntensity intensity = new WrapperHessianBlobIntensity(HessianBlobIntensity.Type.DETERMINANT, derivType);
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(extractRadius, detectThreshold, extractRadius, true));
        GeneralFeatureDetector detector = new GeneralFeatureDetector(intensity, extractor);
        detector.setMaxFeatures(maxFeatures);
        AnyImageDerivative deriv = GImageDerivativeOps.derivativeForScaleSpace(imageType, derivType);
        ImageFunctionSparse sparseLaplace = FactoryDerivativeSparse.createLaplacian(imageType, null);
        return new FeatureLaplacePyramid(detector, sparseLaplace, deriv, 2.0);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> FeatureLaplacePyramid<T, D> harrisLaplace(int extractRadius, float detectThreshold, int maxFeatures, Class<T> imageType, Class<D> derivType) {
        HarrisCornerIntensity<D> harris = FactoryIntensityPointAlg.harris(extractRadius, 0.04f, false, derivType);
        WrapperGradientCornerIntensity intensity = new WrapperGradientCornerIntensity(harris);
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(extractRadius, detectThreshold, extractRadius, true));
        GeneralFeatureDetector detector = new GeneralFeatureDetector(intensity, extractor);
        detector.setMaxFeatures(maxFeatures);
        AnyImageDerivative deriv = GImageDerivativeOps.derivativeForScaleSpace(imageType, derivType);
        ImageFunctionSparse sparseLaplace = FactoryDerivativeSparse.createLaplacian(imageType, null);
        return new FeatureLaplacePyramid(detector, sparseLaplace, deriv, 2.0);
    }

    public static <II extends ImageSingleBand> FastHessianFeatureDetector<II> fastHessian(ConfigFastHessian config) {
        if (config == null) {
            config = new ConfigFastHessian();
        }
        config.checkValidity();
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(config.extractRadius, config.detectThreshold, 5, true));
        return new FastHessianFeatureDetector(extractor, config.maxFeaturesPerScale, config.initialSampleSize, config.initialSize, config.numberScalesPerOctave, config.numberOfOctaves);
    }

    public static SiftDetector siftDetector(ConfigSiftDetector config) {
        if (config == null) {
            config = new ConfigSiftDetector();
        }
        config.checkValidity();
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(config.extractRadius, config.detectThreshold, 2, true, true, true));
        return new SiftDetector(extractor, config.maxFeaturesPerScale, config.edgeThreshold);
    }
}

