/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.dense;

import boofcv.abst.distort.FDistort;
import boofcv.abst.feature.dense.DescribeImageDense;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.dense.DescribeDenseSiftAlg;
import boofcv.alg.filter.misc.AverageDownSampleOps;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class DescribeImageDenseSift<T extends ImageSingleBand, D extends ImageSingleBand>
implements DescribeImageDense<T, TupleDesc_F64> {
    DescribeDenseSiftAlg<D> alg;
    ImageGradient<T, D> gradient;
    FDistort scaleUp;
    double scale;
    double periodX;
    double periodY;
    T imageScaled;
    D derivX;
    D derivY;

    public DescribeImageDenseSift(DescribeDenseSiftAlg<D> alg, Class<T> inputType) {
        this.alg = alg;
        Class<D> gradientType = alg.getDerivType();
        this.gradient = FactoryDerivative.three(inputType, gradientType);
        this.imageScaled = GeneralizedImageOps.createSingleBand(inputType, (int)1, (int)1);
        this.derivX = GeneralizedImageOps.createSingleBand(gradientType, (int)1, (int)1);
        this.derivY = GeneralizedImageOps.createSingleBand(gradientType, (int)1, (int)1);
        this.scaleUp = new FDistort(ImageType.single(inputType));
        this.scaleUp.interp(TypeInterpolate.BILINEAR);
    }

    @Override
    public void configure(double scale, double periodX, double periodY) {
        this.periodX = periodX;
        this.periodY = periodY;
        this.scale = scale;
    }

    @Override
    public void process(T input) {
        if (this.scale == 1.0) {
            this.alg.setPeriodColumns(this.periodX);
            this.alg.setPeriodRows(this.periodY);
        } else {
            int width = (int)((double)((ImageSingleBand)input).width / this.scale + 0.5);
            int height = (int)((double)((ImageSingleBand)input).height / this.scale + 0.5);
            this.imageScaled.reshape(width, height);
            this.derivX.reshape(width, height);
            this.derivY.reshape(width, height);
            if (width < ((ImageSingleBand)input).width) {
                AverageDownSampleOps.down(input, this.imageScaled);
            } else {
                this.scaleUp.setRefs(input, this.imageScaled).scaleExt().apply();
            }
            input = this.imageScaled;
            this.alg.setPeriodColumns(this.periodX / this.scale);
            this.alg.setPeriodRows(this.periodY / this.scale);
        }
        this.derivX.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.derivY.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.gradient.process(input, this.derivX, this.derivY);
        this.alg.setImageGradient(this.derivX, this.derivY);
        this.alg.process();
    }

    @Override
    public List<TupleDesc_F64> getDescriptions() {
        return this.alg.getDescriptors().toList();
    }

    @Override
    public List<Point2D_I32> getLocations() {
        return this.alg.getLocations().toList();
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageScaled.getImageType();
    }

    @Override
    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.alg.getDescriptorLength());
    }

    @Override
    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }

    public DescribeDenseSiftAlg<D> getAlg() {
        return this.alg;
    }
}

