/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.dense;

import boofcv.abst.feature.dense.DescribeImageDense;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class GenericDenseDescribeImageDense<T extends ImageBase, Desc extends TupleDesc>
implements DescribeImageDense<T, Desc> {
    DescribeRegionPoint<T, Desc> alg;
    double scaleToRadius;
    double radius;
    int featureWidth;
    int periodX;
    int periodY;
    FastQueue<Desc> descriptions;
    FastQueue<Point2D_I32> locations = new FastQueue(Point2D_I32.class, true);

    public GenericDenseDescribeImageDense(DescribeRegionPoint<T, Desc> alg, double scaleToRadius) {
        this.scaleToRadius = scaleToRadius;
        this.alg = alg;
    }

    @Override
    public void configure(double scale, double periodX, double periodY) {
        this.radius = scale * this.scaleToRadius;
        this.periodX = (int)(periodX + 0.5);
        this.periodY = (int)(periodY + 0.5);
        this.featureWidth = (int)(this.alg.getCanonicalWidth() * scale + 0.5);
        this.descriptions = new FastQueue<Desc>(this.alg.getDescriptionType(), true){

            protected Desc createInstance() {
                return GenericDenseDescribeImageDense.this.alg.createDescription();
            }
        };
    }

    @Override
    public void process(T input) {
        if (this.periodX <= 0 || this.periodY <= 0) {
            throw new IllegalArgumentException("Must call configure(0 first");
        }
        this.alg.setImage(input);
        int x0 = this.featureWidth / 2;
        int x1 = input.getWidth() - this.featureWidth / 2;
        int y0 = this.featureWidth / 2;
        int y1 = input.getHeight() - this.featureWidth / 2;
        this.descriptions.reset();
        this.locations.reset();
        for (int y = y0; y < y1; y += this.periodY) {
            for (int x = x0; x < x1; x += this.periodX) {
                TupleDesc d = (TupleDesc)this.descriptions.grow();
                if (!this.alg.process(x, y, 0.0, this.radius, d)) {
                    this.descriptions.removeTail();
                    continue;
                }
                ((Point2D_I32)this.locations.grow()).set(x, y);
            }
        }
    }

    @Override
    public List<Desc> getDescriptions() {
        return this.descriptions.toList();
    }

    @Override
    public List<Point2D_I32> getLocations() {
        return this.locations.toList();
    }

    @Override
    public ImageType<T> getImageType() {
        return this.alg.getImageType();
    }

    @Override
    public Desc createDescription() {
        return this.alg.createDescription();
    }

    @Override
    public Class<Desc> getDescriptionType() {
        return this.alg.getDescriptionType();
    }
}

