/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.detect.interest.UnrollSiftScaleSpaceGradient;
import boofcv.core.image.GConvertImage;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;

public class DescribeRegionPoint_SIFT<T extends ImageSingleBand>
implements DescribeRegionPoint<T, TupleDesc_F64> {
    ImageType<T> imageType;
    UnrollSiftScaleSpaceGradient scaleSpace;
    DescribePointSift<ImageFloat32> describe;
    ImageFloat32 imageFloat = new ImageFloat32(1, 1);

    public DescribeRegionPoint_SIFT(SiftScaleSpace scaleSpace, DescribePointSift<ImageFloat32> describe, Class<T> imageType) {
        this.scaleSpace = new UnrollSiftScaleSpaceGradient(scaleSpace);
        this.describe = describe;
        this.imageType = ImageType.single(imageType);
    }

    @Override
    public void setImage(T image) {
        ImageFloat32 input;
        if (image instanceof ImageFloat32) {
            input = (ImageFloat32)image;
        } else {
            this.imageFloat.reshape(((ImageSingleBand)image).width, ((ImageSingleBand)image).height);
            GConvertImage.convert(image, (ImageBase)this.imageFloat);
            input = this.imageFloat;
        }
        this.scaleSpace.setImage(input);
    }

    @Override
    public boolean process(double x, double y, double orientation, double radius, TupleDesc_F64 description) {
        double sigma = radius / 1.0;
        UnrollSiftScaleSpaceGradient.ImageScale image = this.scaleSpace.lookup(sigma);
        this.describe.setImageGradient(image.derivX, image.derivY);
        this.describe.process(x / image.imageToInput, y / image.imageToInput, sigma / image.imageToInput, orientation, description);
        return true;
    }

    @Override
    public boolean requiresRadius() {
        return true;
    }

    @Override
    public boolean requiresOrientation() {
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public double getCanonicalWidth() {
        return this.describe.getCanonicalRadius() * 2;
    }

    @Override
    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.describe.getDescriptorLength());
    }

    @Override
    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }
}

